<?php
/*
 * Acmee Importer
 * @author   KannanC
 * @url     http://acmeedesign.com
*/


defined('ABSPATH') || die;

if (!class_exists('AcmDemoImporter')) {

    class AcmDemoImporter
    {
        
        function __construct() {
            add_action('admin_enqueue_scripts', array($this, 'register_scripts'));
            add_action('admin_menu', array($this, 'register_import_menu'));
            add_action('wp_ajax_acm_import', array($this, 'acm_import'));
            add_action('plugins_loaded', array($this, 'load_wp_importers'), 99);
            add_action( 'admin_init', array($this, 'deactivate_wp_importer_plugin'), 9); //the original plugin raises strict standards 
            //warning https://core.trac.wordpress.org/ticket/24373
        }
        
        function register_scripts(){
                wp_enqueue_style( 'acm-import-styles', plugins_url( '/assets/css/import-style.css', __FILE__ ) );
                wp_register_script( "acm-importscript", plugins_url( '/assets/js/script.js', __FILE__) , array('jquery') );
                wp_localize_script( 'acm-importscript', 'acmAjax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' )));        

                wp_enqueue_script( 'jquery' );
                wp_enqueue_script( 'acm-importscript' );
        }
        
        function register_import_menu() {
            add_submenu_page( 'themes.php', __('Import demo content', 'acmee'), __('Import Demo', 'acmee'), 'manage_options', 'acm_import_demo', array($this, 'import_page') );
        }
        
        function deactivate_wp_importer_plugin() {
            if(function_exists('is_plugin_active')) {
                if ( is_plugin_active('wordpress-importer/wordpress-importer.php') ) {
                    deactivate_plugins('wordpress-importer/wordpress-importer.php');    
                }
            }
        }
        
        function load_wp_importers() {
            if ( !defined('WP_LOAD_IMPORTERS') ){ 
                    define('WP_LOAD_IMPORTERS', true); 
            }
        }
                
        function import_page() {
            ?>
            <div class="wrap acm-wrapper">
                
                <h2><?php echo __('Import demo content', 'acmee'); ?></h2>
                <p><?php echo __('Please select the required content to import.', 'acmee'); ?></p>
                <form action="" name="acm-importer" id="acm-importer" method="post">
                    <div class="label">
                        <div class="title"><?php _e('Demo Pages', 'acmee'); ?></div>
                        <label for="acm_demo_pages">
                            <input type="checkbox" name="acm_demo_pages" class="acm_demo_pages" value="1" /> Import demo pages
                        </label>
                    </div>
                    <div class="label">
                        <?php
                        $bks_theme_styles = bookstore_theme_styles();
                        if(is_array($bks_theme_styles) && !empty($bks_theme_styles)) {
                            
                                ?>
                        <div class="title"><?php _e('Theme Options', 'acmee'); ?></div>
                        <label for="acm_theme_options">
                            <select name="acm_theme_options" class="acm_theme_options">
                                <option value=""><?php _e('Select Theme Style', 'acmee'); ?></option>
                                <?php
                                foreach ($bks_theme_styles as $style_name => $style_data) {
                                    ?>
                                <option value="<?php echo esc_html($style_name); ?>"><?php echo esc_html(ucwords($style_name)); ?></option>
                                <?php
                                }
                                ?>
                            </select>                                
                        </label>
                        <?php
                            
                        }
                            ?>

                    </div>
                    
                     <div class="label">
                         <div class="title"><?php _e('Widgets', 'acmee'); ?></div>
                        <label for="acm_default_widgets">
                            <input type="checkbox" name="acm_widgets" class="acm_widgets" value="1" /> <?php _e('Import widgets', 'acmee'); ?>
                        </label>
                    </div>

                    <div class="label">
                        <label for="acm_submit">
                            <button id="acm-submit" type="submit" value="Submit" class="button button-primary button-large"><?php _e('Import', 'acmee'); ?></button>
                        </label>
                    </div>
                    
                    <?php wp_nonce_field( 'action_acm_import', 'acm_importer_nonce' ); ?>
                </form>
                <div id="result"><img src="<?php echo plugins_url( 'assets/images/gears.gif', __FILE__ ) ?>" id="loader" class="hide" /></div>
            </div>

<?php
        }
        
        function load_wp_importer() {
            if ( ! class_exists( 'WP_Importer' ) ) {
                    include ABSPATH . 'wp-admin/includes/class-wp-importer.php';
            }

            if ( ! class_exists('WP_Import') ) {
                    include_once dirname(__FILE__) . '/importer-class/wordpress-importer.php';
            }
        }
        
        function acm_import() {

            if ( !wp_verify_nonce( $_POST['acm_importer_nonce'], "action_acm_import")) {
               exit("Permission denied!");
            }     
            
            $success_msg = array();
            
            if(isset($_POST['demo_content'])) {
                
                $file_path = get_template_directory() . '/includes/demo-content/bks-import.2016-07-06.xml';
                
                $this->load_wp_importer();
                $wp_importer = new WP_Import();
                $wp_importer->fetch_attachments = true;
                ob_start();
                $wp_importer->import($file_path);
                ob_end_clean();
                
                //set menu settings
                $this->menu_settings();
                
                //set front page and blog page
                $this->page_settings();
                
                if(class_exists('VC_MegaMenu')) {
                    $bks_mega_menus =  'Main Menu';
                    $term = get_term_by( 'name', $bks_mega_menus, 'nav_menu');
                    $settings = VC_MegaMenu::default_nav_settings();
                    $settings['enable'] = 1;
                    update_term_meta( $term->term_id, '_vc_mm_settings',  $settings );
                }
                
                $success_msg['demo'] = "Demo content installed Successfully!";
                
            }
            
            if(isset($_POST['theme_options'])) { 
                $bks_theme_styles = bookstore_theme_styles(); 
                if( !empty($bks_theme_styles)) {
                    $chosen_style = unserialize($bks_theme_styles[$_POST['theme_options']]);
                    update_option('bookstore_settings', $chosen_style);
                    $success_msg['theme-option'] = "Styles imported"; 
                }
            }
            
            if(isset($_POST['default_widgets'])) {
                $bks_default_widgets = bookstore_default_widgets();
                $widget_data = json_decode( $bks_default_widgets );
                 $widget_imp_result = $this->acm_import_widget($widget_data);
                 $success_msg['default-widgets'] = (is_array($widget_imp_result)) ? __('Widgets imported successfully!', 'acmee') : __('Widget import error!', 'acmee');
            }
            
            foreach ($success_msg as $msg) {
                echo $msg;
            }

            exit();

         }
         
         function menu_settings() {
                $menu_locations = get_theme_mod( 'nav_menu_locations' );
                $menu_items = wp_get_nav_menus();

                if( !empty($menu_items) ) {
                        foreach($menu_items as $menu) {
                                if( $menu->name == 'Main Menu' ) {
                                        $menu_locations['primary'] = $menu->term_id;
                                }
                                if( $menu->name == 'Top bar' ) {
                                        $menu_locations['topbar'] = $menu->term_id;
                                }
                        }
                }
                set_theme_mod( 'nav_menu_locations', $menu_locations );
         }
         
         function page_settings() {
            $get_home = get_page_by_title( 'Home' );
            $get_blog = get_page_by_title( 'Blog' );
            
            if( isset( $get_home ) && $get_home->ID ){
                    update_option('show_on_front', 'page');
                    update_option('page_on_front', $get_home->ID);
            }
            
            if( isset( $get_blog ) && $get_blog->ID ){
                    update_option('page_for_posts', $get_blog->ID);
            }
            
         }
         
         function acm_import_widget( $data ) {

            global $wp_registered_sidebars;

            // Have valid data?
            // If no data or could not decode
            if ( empty( $data ) || ! is_object( $data ) ) {
                            $data_error = __('No widget data.', 'acmee');
                            return $data_error;
            }

            // Get all available widgets site supports
            $available_widgets = $this->acm_available_widgets();

            // Get all existing widget instances
            $widget_instances = array();
            foreach ( $available_widgets as $widget_data ) {
                    $widget_instances[$widget_data['id_base']] = get_option( 'widget_' . $widget_data['id_base'] );
            }

            // Begin results
            $results = array();

            // Loop import data's sidebars
            foreach ( $data as $sidebar_id => $widgets ) {

                    // Skip inactive widgets
                    // (should not be in export file)
                    if ( 'wp_inactive_widgets' == $sidebar_id ) {
                            continue;
                    }

                    // Check if sidebar is available on this site
                    // Otherwise add widgets to inactive, and say so
                    if ( isset( $wp_registered_sidebars[$sidebar_id] ) ) {
                            $sidebar_available = true;
                            $use_sidebar_id = $sidebar_id;
                            $sidebar_message_type = 'success';
                            $sidebar_message = '';
                    } else {
                            $sidebar_available = false;
                            $use_sidebar_id = 'wp_inactive_widgets'; // add to inactive if sidebar does not exist in theme
                            $sidebar_message_type = 'error';
                            $sidebar_message = __( 'Sidebar does not exist in theme (using Inactive)', 'acmee' );
                    }

                    // Result for sidebar
                    $results[$sidebar_id]['name'] = ! empty( $wp_registered_sidebars[$sidebar_id]['name'] ) ? $wp_registered_sidebars[$sidebar_id]['name'] : $sidebar_id; // sidebar name if theme supports it; otherwise ID
                    $results[$sidebar_id]['message_type'] = $sidebar_message_type;
                    $results[$sidebar_id]['message'] = $sidebar_message;
                    $results[$sidebar_id]['widgets'] = array();

                    // Loop widgets
                    foreach ( $widgets as $widget_instance_id => $widget ) {

                            $fail = false;

                            // Get id_base (remove -# from end) and instance ID number
                            $id_base = preg_replace( '/-[0-9]+$/', '', $widget_instance_id );
                            $instance_id_number = str_replace( $id_base . '-', '', $widget_instance_id );

                            // Does site support this widget?
                            if ( ! $fail && ! isset( $available_widgets[$id_base] ) ) {
                                    $fail = true;
                                    $widget_message_type = 'error';
                                    $widget_message = __( 'Site does not support widget', 'acmee' ); // explain why widget not imported
                            }

                            // Filter to modify settings object before conversion to array and import
                            // Leave this filter here for backwards compatibility with manipulating objects (before conversion to array below)
                            // Ideally the newer wie_widget_settings_array below will be used instead of this
                            $widget = apply_filters( 'wie_widget_settings', $widget ); // object

                            // Convert multidimensional objects to multidimensional arrays
                            // Some plugins like Jetpack Widget Visibility store settings as multidimensional arrays
                            // Without this, they are imported as objects and cause fatal error on Widgets page
                            // If this creates problems for plugins that do actually intend settings in objects then may need to consider other approach: https://wordpress.org/support/topic/problem-with-array-of-arrays
                            // It is probably much more likely that arrays are used than objects, however
                            $widget = json_decode( json_encode( $widget ), true );

                            // Filter to modify settings array
                            // This is preferred over the older wie_widget_settings filter above
                            // Do before identical check because changes may make it identical to end result (such as URL replacements)
                            $widget = apply_filters( 'wie_widget_settings_array', $widget );

                            // Does widget with identical settings already exist in same sidebar?
                            if ( ! $fail && isset( $widget_instances[$id_base] ) ) {

                                    // Get existing widgets in this sidebar
                                    $sidebars_widgets = get_option( 'sidebars_widgets' );
                                    $sidebar_widgets = isset( $sidebars_widgets[$use_sidebar_id] ) ? $sidebars_widgets[$use_sidebar_id] : array(); // check Inactive if that's where will go

                                    // Loop widgets with ID base
                                    $single_widget_instances = ! empty( $widget_instances[$id_base] ) ? $widget_instances[$id_base] : array();
                                    foreach ( $single_widget_instances as $check_id => $check_widget ) {

                                            // Is widget in same sidebar and has identical settings?
                                            if ( in_array( "$id_base-$check_id", $sidebar_widgets ) && (array) $widget == $check_widget ) {

                                                    $fail = true;
                                                    $widget_message_type = 'warning';
                                                    $widget_message = __( 'Widget already exists', 'acmee' ); // explain why widget not imported

                                                    break;

                                            }

                                    }

                            }

                            // No failure
                            if ( ! $fail ) {

                                    // Add widget instance
                                    $single_widget_instances = get_option( 'widget_' . $id_base ); // all instances for that widget ID base, get fresh every time
                                    $single_widget_instances = ! empty( $single_widget_instances ) ? $single_widget_instances : array( '_multiwidget' => 1 ); // start fresh if have to
                                    $single_widget_instances[] = $widget; // add it

                                            // Get the key it was given
                                            end( $single_widget_instances );
                                            $new_instance_id_number = key( $single_widget_instances );

                                            // If key is 0, make it 1
                                            // When 0, an issue can occur where adding a widget causes data from other widget to load, and the widget doesn't stick (reload wipes it)
                                            if ( '0' === strval( $new_instance_id_number ) ) {
                                                    $new_instance_id_number = 1;
                                                    $single_widget_instances[$new_instance_id_number] = $single_widget_instances[0];
                                                    unset( $single_widget_instances[0] );
                                            }

                                            // Move _multiwidget to end of array for uniformity
                                            if ( isset( $single_widget_instances['_multiwidget'] ) ) {
                                                    $multiwidget = $single_widget_instances['_multiwidget'];
                                                    unset( $single_widget_instances['_multiwidget'] );
                                                    $single_widget_instances['_multiwidget'] = $multiwidget;
                                            }

                                            // Update option with new widget
                                            update_option( 'widget_' . $id_base, $single_widget_instances );

                                    // Assign widget instance to sidebar
                                    $sidebars_widgets = get_option( 'sidebars_widgets' ); // which sidebars have which widgets, get fresh every time
                                    $new_instance_id = $id_base . '-' . $new_instance_id_number; // use ID number from new widget instance
                                    $sidebars_widgets[$use_sidebar_id][] = $new_instance_id; // add new instance to sidebar
                                    update_option( 'sidebars_widgets', $sidebars_widgets ); // save the amended data

                                    // After widget import action
                                    $after_widget_import = array(
                                            'sidebar'           => $use_sidebar_id,
                                            'sidebar_old'       => $sidebar_id,
                                            'widget'            => $widget,
                                            'widget_type'       => $id_base,
                                            'widget_id'         => $new_instance_id,
                                            'widget_id_old'     => $widget_instance_id,
                                            'widget_id_num'     => $new_instance_id_number,
                                            'widget_id_num_old' => $instance_id_number
                                    );
                                    do_action( 'wie_after_widget_import', $after_widget_import );

                                    // Success message
                                    if ( $sidebar_available ) {
                                            $widget_message_type = 'success';
                                            $widget_message = __( 'Imported', 'acmee' );
                                    } else {
                                            $widget_message_type = 'warning';
                                            $widget_message = __( 'Imported to Inactive', 'acmee' );
                                    }

                            }

                            // Result for widget instance
                            $results[$sidebar_id]['widgets'][$widget_instance_id]['name'] = isset( $available_widgets[$id_base]['name'] ) ? $available_widgets[$id_base]['name'] : $id_base; // widget name or ID if name not available (not supported by site)
                            $results[$sidebar_id]['widgets'][$widget_instance_id]['title'] = ! empty( $widget['title'] ) ? $widget['title'] : __( 'No Title', 'acmee' ); // show "No Title" if widget instance is untitled
                            $results[$sidebar_id]['widgets'][$widget_instance_id]['message_type'] = $widget_message_type;
                            $results[$sidebar_id]['widgets'][$widget_instance_id]['message'] = $widget_message;

                    }

            }

            // Return results
            return apply_filters( 'wie_import_results', $results );

          }
          
          function acm_available_widgets() {

            global $wp_registered_widget_controls;

            $widget_controls = $wp_registered_widget_controls;

            $available_widgets = array();

            foreach ( $widget_controls as $widget ) {

                    if ( ! empty( $widget['id_base'] ) && ! isset( $available_widgets[$widget['id_base']] ) ) { // no dupes

                            $available_widgets[$widget['id_base']]['id_base'] = $widget['id_base'];
                            $available_widgets[$widget['id_base']]['name'] = $widget['name'];

                    }

            }

            return apply_filters( 'acm_available_widgets', $available_widgets );

        }
       

        
        
    }
    
    new AcmDemoImporter();
    
}