<?php
/* 
 * @package   bookstore
 * @author    AcmeeDesign
 * @link      http://acmeedesign.com
 * @since     1.0
 */

//enable shortcodes in widgets
  add_filter('widget_text', 'do_shortcode');
    
if( !function_exists('bks_custom_heading_render') ){    
    function bks_custom_heading_render( $atts ) {
       extract( shortcode_atts( array(
          'heading_text' => '',
          'description' => '',
          'line_height' => '21',
          'font_size' => '18',
          'text_color' => '#333333',
           'el_class' => '',
       ), $atts ) );
     
       $font_size = acm_clean_font_size($font_size);
       $line_height = acm_clean_font_size($line_height);
        
        $output = "<div class='bks-heading {$el_class}'>";
        $output .= "<h3 class='bks-title'>";
        $output .= "<span style='font-size:{$font_size}px;color:{$text_color};line-height:{$line_height}px'>{$heading_text}</span>";
        $output .= "</h3>";
        
        if(!empty($description)) {
            $output .= "<div class='bks_descrition'>{$description}</div>";
        }
        $output .= "</div>";
       
       return $output;
    }
}
add_shortcode( 'bksheading', 'bks_custom_heading_render' );


if( !function_exists('bks_fbox_render') ){    
    function bks_fbox_render( $atts ) {
       extract( shortcode_atts( array(
            'f_style' => 'style1',
            'fbox_color' => '#27ae61',
            'f_text_color' => '#ffffff',
            'f_icon_color' => '#ffffff',
            'f_item_1_heading' => '',
            'f_item_1_desc' => '',
            'f_link_text_1' => 'Read more',
            'f_link_1' => '#',
            'f_icon_1' => '',
            'f_item_2_heading' => '',
            'f_item_2_desc' => '',
            'f_link_text_2' => 'Read more',
            'f_link_2' => '#',
            'f_icon_2' => '',
            'f_item_3_heading' => '',
            'f_item_3_desc' => '',
            'f_link_text_3' => 'Read more',
            'f_link_3' => '#',
            'f_icon_3' => '',
           'el_class' => '',
       ), $atts ) );
       
       if($f_style == "style3") {
           
           $output = "<div class='jb-features-3 {$el_class}'>";
           //column 1
            $output .= "<div class='jb-features-block col-sm-12 col-md-4 col-lg-4 col-xs-12'>
                <div class='jb-icon'><em class='{$f_icon_1}'></em></div>
                <div class='jb-features-content'>
                <h4>{$f_item_1_heading}</h4>
                <p>{$f_item_1_desc}</p>";
                if(!empty($f_link_text_1)) {
                    $output .= "<h5><a href='{$f_link_1}' class='btn btn-link'>{$f_link_text_1}</a></h5>";
                 }
                $output .= "</div>
                    </div>";
                
                //column 2
                $output .= "<div class='jb-features-block col-sm-12 col-md-4 col-lg-4 col-xs-12'>
                    <div class='jb-icon'><em class='{$f_icon_2}'></em></div>
                    <div class='jb-features-content'>
                    <h4>{$f_item_2_heading}</h4>
                    <p>{$f_item_2_desc}</p>";
                    if(!empty($f_link_text_2)) {
                        $output .= "<h5><a href='{$f_link_2}' class='btn btn-link'>{$f_link_text_2}</a></h5>";
                     }
                    $output .= "</div>
                        </div>";
                
                //column 3
                $output .= "<div class='jb-features-block col-sm-12 col-md-4 col-lg-4 col-xs-12'>
                    <div class='jb-icon'><em class='{$f_icon_3}'></em></div>
                    <div class='jb-features-content'>
                    <h4>{$f_item_3_heading}</h4>
                    <p>{$f_item_3_desc}</p>";
                    if(!empty($f_link_text_3)) {
                        $output .= "<h5><a href='{$f_link_3}' class='btn btn-link'>{$f_link_text_3}</a></h5>";
                     }
                    $output .= "</div>
                        </div>";
                    
                    $output .= "</div>";
       }
       else {
           $f_class = ($f_style == "style2") ? "feature-box-style1" : "";
            $output = "<div style='background-color:{$fbox_color};color:{$f_text_color};' class='jb-features t3-spotlight t3-spotlight-1 clearfix {$f_class} {$el_class}'>";

            $output .= "<div class='col-lg-4 col-md-12 col-sm-10 col-xs-12'>
                 <div class='t3-module module border-right col-sm-offset-2 col-lg-offset-0 '>
                     <div class='custom border-right col-sm-offset-2 col-lg-offset-0'>

                         <div class='jb-icon-with-description'>
                             <em class='{$f_icon_1}'></em>
                             <h4 style='color:{$f_text_color}'>{$f_item_1_heading}</h4>
                             <p>{$f_item_1_desc}</p>
                         </div>
                     </div>
                 </div>
             </div>";

             $output .= "
             <div class='col-lg-4 col-md-12 col-sm-10 col-xs-12'>
                 <div class='t3-module module border-right col-sm-offset-2 col-lg-offset-0 '>
                     <div class='custom border-right col-sm-offset-2 col-lg-offset-0'>

                         <div class='jb-icon-with-description'>
                             <em class='{$f_icon_2}'></em>
                             <h4 style='color:{$f_text_color}'>{$f_item_2_heading}</h4>
                             <p>{$f_item_2_desc}</p>
                         </div>
                     </div>
                 </div>
             </div>";

             $output .= "
             <div class='col-lg-4 col-md-12 col-sm-10 col-xs-12'>
                 <div class='t3-module module col-sm-offset-2 col-lg-offset-0 '>
                     <div class='custom col-sm-offset-2 col-lg-offset-0'>

                         <div class='jb-icon-with-description'>
                             <em class='{$f_icon_3}'></em>
                             <h4 style='color:{$f_text_color}'>{$f_item_3_heading}</h4>
                             <p>{$f_item_3_desc}</p>
                         </div>
                     </div>
                 </div>
             </div>";
             $output .= "</div>";
       }

       return $output;
    }
}
add_shortcode( 'bks_fbox', 'bks_fbox_render' );

if( !function_exists('bks_banner_render') ){    
    function bks_banner_render( $atts ) {
       extract( shortcode_atts( array(
          'banner_type' => '',
          'bn_heading' => 'Heading',
          'bn_desc' => 'Description',
          'link_text' => '',
          'bn_link' => '',
          'bg_color' => '#323232',
          'head_color' => '#27ae61',
          'desc_color' => '#323232',
          'link_color' => '#212121',
          'img_for_banner' => '',
           'el_class' => '',
       ), $atts ) );
       
       $imgurl = (!empty($img_for_banner)) ? acm_get_image_url($img_for_banner) : "";
       $bg_color_style = (!empty($bg_color)) ? "style='background-color:{$bg_color}'" : ""; 
       $desc_color_style = (!empty($desc_color)) ? "style='color:{$desc_color}'" : "";
       $head_color_style = (!empty($head_color)) ? "style='color:{$head_color}'" : "";
       $link_color_style = (!empty($link_color)) ? "style='color:{$link_color}'" : "";

       if($banner_type == 'image_bg') {
           //Show image banner
            $output = "<div class='{$el_class}'>
                <div class='dis-bottom-left'>
                <div class='dis-bottom-left-img'><img src='{$imgurl}' alt='{$bn_heading}'>
                <div class='dis-bottom-left-content'>
                <div class='dis-bottom-left-text'>
                <h6 {$desc_color_style}>{$bn_desc}</h6>
                <h2 {$head_color_style}>{$bn_heading}</h2>";
                if(!empty($link_text)) {
                    $output .= "<a href='{$bn_link}' {$link_color_style} class='btn-link'>{$link_text} <em class='fa fa-long-arrow-right'></em></a>";
                }
                $output .= "</div>
                </div>
                </div>
                </div></div>";
       }
       elseif($banner_type == 'color_bg') {
           //Show color banner
           $output = "<div class='{$el_class}'>
               <div class='banner banner-info' {$bg_color_style}>
                <div class='banner-info-wrapper'>
                <h4>{$bn_heading}</h4>
                <p>{$bn_desc}</p>";
          if(!empty($link_text)) {
             $output .= "<a href='{$bn_link}' {$link_color_style} class='btn-link'>{$link_text} <em class='fa fa-long-arrow-right'></em></a>";
          }
          $output .= " </div>
               </div> </div>";
       }
       return $output;
    }
}
add_shortcode( 'bksbanner', 'bks_banner_render' );

/*
 * WooCommerce Products Carousel
 */
if( !function_exists('bks_woo_carousel_render') ){    
    function bks_woo_carousel_render( $atts ) {
       extract( shortcode_atts( array(
          'products_count' => '12',
          'pr_order_by' => 'Date',
          'pr_sort_order' => 'DESC',
          'pr_filter' => 'recent_products',
          'category_id' => '',
          'product_ids' => '',
          'el_class' => '',
       ), $atts ) );
       
       $uniq_id = "carousel_" . acm_rand_key(5);
       
       if(!empty($product_ids)) {
           $single_products = explode(',', $product_ids);
       }
        else {
            $single_products = "";
       }

       if($pr_filter == "category") {
            $args = array(  
                 'post_type' => 'product',  
                 'tax_query' => array(
                    array(
                            'taxonomy' => 'product_cat',
                            'field' => 'id',
                            'terms' => $category_id
                            )
                    ),
                 'ignore_sticky_posts'   => 1,
                 'posts_per_page' => $products_count,
                 'orderby' => $pr_order_by,
                 'order'   => $pr_sort_order,
             ); 
       }
       elseif($pr_filter == "featured") {
           $args = array(  
                 'post_type' => 'product',  
                 'meta_key' => '_featured',  
                 'meta_value' => 'yes',  
                 'posts_per_page' => $products_count,
                 'orderby' => $pr_order_by,
                 'order'   => $pr_sort_order,
             ); 
       }
       elseif($pr_filter == "top_selling") {
           $args = array(  
                 'post_type' => 'product',  
                 'meta_key' => 'total_sales',  
                 'posts_per_page' => $products_count,
                 'orderby' => 'meta_value_num',
                 'order'   => $pr_sort_order,
             ); 
       }
       elseif($pr_filter == "single_products") {
           $args = array(  
                 'post_type' => 'product',  
                 'post__in' => $single_products,
                 'posts_per_page' => $products_count,
                 'orderby' => $pr_order_by,
                 'order'   => $pr_sort_order,
             ); 
       }
       else {
           $args = array(  
                 'post_type' => 'product',  
                 'posts_per_page' => $products_count,
                 'orderby' => $pr_order_by,
                 'order'   => $pr_sort_order,
             ); 
       }
       
       ob_start();
       
       $output = "";
       $woo_query = new WP_Query($args); 
       if ($woo_query->have_posts()) :
          echo "<div class='woocommerce bks-product-slider {$el_class}'>";
          echo "<div class='carousel-controls'>
               <div class='owl-prev'>
                    <a class='prev'><i class='fa fa-angle-left'></i></a>
               </div>
               <div class='owl-next'>
                    <a class='next'><i class='fa fa-angle-right'></i></a>
               </div>
              </div>
              <div id='{$uniq_id}' class='owl-carousel'>";
       
          while ($woo_query->have_posts()) :
                $woo_query->the_post();
                wc_get_template_part( 'content', 'carousel' );
          endwhile;
            
          echo '</div>';
          echo '</div>'; //clode of .bks-product-slider
            
        wp_reset_postdata();
        
        else:
       echo __( 'No Products', 'bookstore' ); 

       endif;
       
       $content = ob_get_contents();
       ob_end_clean();
       
       return $content;

    }
}
add_shortcode( 'bks_woo_carousel', 'bks_woo_carousel_render' );


if( !function_exists('bks_post_slider_render') ){    
    function bks_post_slider_render( $atts ) {
       extract( shortcode_atts( array(
          'posts_count' => '6',
          'post_filter' => 'recent',
          'post_order_by' => 'Date',
          'post_sort_order' => 'DESC',
          'category_id' => '',
          'blog_link' => '',
          'el_class' => '',
       ), $atts ) );     
        
        if($post_filter == "category") {
            $args = array(  
                 'post_type' => 'post',  
                 'tax_query' => array(
                    array(
                            'taxonomy' => 'category',
                            'field' => 'id',
                            'terms' => $category_id
                            )
                    ),
                 'ignore_sticky_posts'   => 1,
                 'posts_per_page' => $posts_count,
                 'orderby' => $post_order_by,
                 'order'   => $post_sort_order,
             ); 
       }
       else {
           $args = array(  
                 'post_type' => 'post',  
                 'posts_per_page' => $posts_count,
                 'orderby' => $post_order_by,
                 'order'   => $post_sort_order,
             ); 
       }
       
       $posts_query = new WP_Query($args); 
       if ($posts_query->have_posts()) {
           ob_start();
        ?>
            <div class="bks-post-slider clearfix <?php if(!empty($el_class)) echo $el_class; ?>" data-slick='{"slidesToShow": 3, "slidesToScroll": 3}'>
<?php            
            while ($posts_query->have_posts()) :
                $posts_query->the_post();
                include 'wp-posts/content-posts-slider.php';
            endwhile;
            ?>
            </div>   
<?php
            if(!empty($blog_link)) {
                echo "<div class='text-center'>";
                echo "<a href='{$blog_link}' class='btn-primary view-all-posts-btn'>";
                echo __('View all post ', 'bookstore');
                echo "</a>";
                echo "</div>";
            }
            
       } 
       else {
            get_template_part( 'no-posts', 'index' );
        }
       $content = ob_get_contents();
       ob_end_clean();
       wp_reset_postdata();
       
       return $content;
    }
}
add_shortcode( 'bks_post_slider', 'bks_post_slider_render' );


/*
 * WooCommerce Products list
 */
if( !function_exists('bks_woo_products_list_render') ){    
    function bks_woo_products_list_render( $atts ) {
       extract( shortcode_atts( array(
          'products_count' => '12',
          'pr_order_by' => 'Date',
          'pr_sort_order' => 'DESC',
          'pr_filter' => 'recent_products',
          'category_id' => '',
          'product_ids' => '',
          'el_class' => '',
       ), $atts ) );
       
       if(!empty($product_ids)) {
           $single_products = explode(',', $product_ids);
       }
        else {
            $single_products = "";
       }

       if($pr_filter == "category") {
            $args = array(  
                 'post_type' => 'product',  
                 'tax_query' => array(
                    array(
                            'taxonomy' => 'product_cat',
                            'field' => 'id',
                            'terms' => $category_id
                            )
                    ),
                 'ignore_sticky_posts'   => 1,
                 'posts_per_page' => $products_count,
                 'orderby' => $pr_order_by,
                 'order'   => $pr_sort_order,
             ); 
       }
       elseif($pr_filter == "featured") {
           $args = array(  
                 'post_type' => 'product',  
                 'meta_key' => '_featured',  
                 'meta_value' => 'yes',  
                 'posts_per_page' => $products_count,
                 'orderby' => $pr_order_by,
                 'order'   => $pr_sort_order,
             ); 
       }
       elseif($pr_filter == "top_selling") {
           $args = array(  
                 'post_type' => 'product',  
                 'meta_key' => 'total_sales',  
                 'posts_per_page' => $products_count,
                 'orderby' => 'meta_value_num',
                 'order'   => $pr_sort_order,
             ); 
       }
       elseif($pr_filter == "single_products") {
           $args = array(  
                 'post_type' => 'product',  
                 'post__in' => $single_products,
                 'posts_per_page' => $products_count,
                 'orderby' => $pr_order_by,
                 'order'   => $pr_sort_order,
             ); 
       }
       else {
           $args = array(  
                 'post_type' => 'product',  
                 'posts_per_page' => $products_count,
                 'orderby' => $pr_order_by,
                 'order'   => $pr_sort_order,
             ); 
       }
       
       $output = "";
       $woo_query = new WP_Query($args); 
       if ($woo_query->have_posts()) :
          $output = "<div class='bks-product-list-wrap {$el_class}'>";
          $output .= "<ul class='bks-products-list-container'>";
       
          while ($woo_query->have_posts()) :
                $woo_query->the_post();
                 include('woocommerce/content-productlist.php');
          endwhile;
          
          $output .= "</ul>"; // .bks-products-list-container
          $output .= "</div>"; // .bks-product-list-wrap
            
        wp_reset_postdata();
        
        else:
       $output = __( 'No Products', 'bookstore' ); 

       endif;
       
       return $output;

    }
}
add_shortcode( 'bks_woo_product_list', 'bks_woo_products_list_render' );

/*
 * BKS Testimonial carousel
 */
if( !function_exists('bks_testimonial_carousel_render') ){    
    function bks_testimonial_carousel_render( $atts ) {
       extract( shortcode_atts( array(
          'tsm_count' => '5',
          'tsm_order_by' => 'Date',
          'tsm_sort_order' => 'DESC',
          'tsm_categories' => '',
           'font_color' => '#999999',
           'font_size_tsm' => '18',
           'font_size_author_names' => '13',
           'font_style' => 'italic',
           'el_class' => '',
       ), $atts ) );
       
       $uniq_id = "bks_slider_" . acm_rand_key(5);
       
       if(empty($tsm_categories)) {
            $args = array(  
                 'post_type' => 'bks_testmonials',  
                 'posts_per_page' => $tsm_count,
                 'orderby' => $tsm_order_by,
                 'order'   => $tsm_sort_order,
             ); 
       }
       else {
           $args = array(  
                'post_type' => 'bks_testmonials',  
                'tax_query' => array(
                    array(
                            'taxonomy' => 'testimonial_categories',
                            'field' => 'slug',
                            'terms' => $tsm_categories
                            )
                    ),
                 'ignore_sticky_posts'   => 1,
                 'posts_per_page' => $tsm_count
             ); 
       }
       
       $font_size_tsm = acm_clean_font_size($font_size_tsm);
       $font_size_author_names = acm_clean_font_size($font_size_author_names);
       
       $output = "";
       $woo_query = new WP_Query($args); 
       if ($woo_query->have_posts()) :
          echo "<div id='{$uniq_id}' class='bks-testimonial-slider {$el_class}' style='color:{$font_color};font-size:{$font_size_tsm}px;font-style={$font_size_author_names}'>";
          echo "<ul id='bks-testimonial-slider' class='gallery list-unstyled cS-hidden'>";
          
          while ($woo_query->have_posts()) :
                $woo_query->the_post();
                wc_get_template_part( 'content', 'testimonials' );
          endwhile;
          
          echo '</ul>'; // #bks-testimonial-slider
          echo '</div>'; // .bks-testimonial-slider
            
        wp_reset_postdata();
        
        else:
       echo __( 'No Testimonials found.', 'bookstore' ); 

       endif;

    }
}
add_shortcode( 'bks_testimonial', 'bks_testimonial_carousel_render' );

/*
 * BKS Icon List
 */
if( !function_exists('bks_icon_list_render') ){    
    function bks_icon_list_render( $atts, $content = null ) {
       extract( shortcode_atts( array(
          'list_icon' => 'fa-paper-plane',
          'icon_color' => '27ae61',
          'icon_css' => '',
          'content_css' => '',
           'el_class' => '',
       ), $atts ) );
      
       $icon_color = "#" . acm_clean_color_code($icon_color);
       $icon_styles = "";
       $content_styles = "";
       
       if(!empty($icon_css)) {
           $icon_csses = explode('|', $icon_css);
           foreach ($icon_csses as $icon_style ) {
                $icon_styles .= $icon_style . ";";
            }
       }
       
       if(!empty($content_css)) {
           $content_csses = explode('|', $content_css);
           foreach ($content_csses as $content_style) {
                $content_styles .= $content_style . ";";
            }
       }
       
       $output = "<ul class='bks_icon_list {$el_class}'>";
       $output .= "<li>";
       $output .= "<em style='color:{$icon_color};$icon_styles' class='fa {$list_icon}'></em>";
       $output .= "<div class='list_content' style='{$content_styles}'>{$content}</div>";
       $output .= "</li>";
       $output .= "</ul>";
       
       return $output;
    }
}
add_shortcode( 'bks_icon_list', 'bks_icon_list_render' );

/*
 * BKS VC List Icons
 */
if( !function_exists('bks_vc_list_icons_render') ){    
    function bks_vc_list_icons_render( $atts, $content = null ) {
        extract( shortcode_atts( array(
          'title_text' => '',
          'title_tag' => 'h2',
          'title_link' => '',
          'list_icon' => '',
          'icon_size' => '',
          'text_color' => '#666666',
          'icon_bg_color' => '#225793',
          'icon_color' => '#ffffff',
           'el_class' => '',
       ), $atts ) );
        
        if($icon_size == "Small") {
            $icon_size_class = "vc_icon_element-size-sm";
        }
        elseif($icon_size == "Normal") {
            $icon_size_class = "vc_icon_element-size-md";
        }
        elseif($icon_size == "Large") {
            $icon_size_class = "vc_icon_element-size-lg";
        }
        elseif($icon_size == "Max") {
            $icon_size_class = "vc_icon_element-size-xl";
        }
        else {
            $icon_size_class = "vc_icon_element-size-xs";
        }
        
        $output = "<div class='bks_list_icons {$el_class}'>";
        $output .= "<div class='vc_icon_element vc_icon_element-outer vc_icon_element-align-left'>";
        $output .= "<div style='background-color:{$icon_bg_color}' class='vc_icon_element-inner vc_icon_element-color-white vc_icon_element-have-style-inner vc_icon_element-style-rounded {$icon_size_class}'>";
        $output .= "<span style='color:{$icon_color}' class='vc_icon_element-icon {$list_icon}'>";
        $output .= "</span>";
        $output .= "</div>";
        $output .= "</div>";
        if(!empty($title_link)) {
            $output .= "<a href='{$title_link}'>";
            $output .= '<' . $title_tag . ' style="color:' . $text_color . '">' . $title_text . '</' . $title_tag . '>';
            $output .= "</a>";
        }
        else {
            $output .= '<' . $title_tag . ' style="color:' . $text_color . '">' . $title_text . '</' . $title_tag . '>';
        }
        $output .= "</div>";
        return $output;
    }
}
add_shortcode( 'bks_icon_with_text', 'bks_vc_list_icons_render' );