<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 */

get_header(); 

$bookstore_options = (function_exists('bookstore_options')) ? bookstore_options() : "";

?>

<div class="container padding-40-v">
    <div id="main-content" class="col-xs-12 text-center">
            <article id="post-0" class="error404 not-found">
                    <header class="entry-header">
                        <span class="error-code-404"><?php esc_html_e ('404', 'bookstore'); ?></span>
                            <h1 class="error-title">
                                <?php 
                                if(isset($bookstore_options['error404-title'])) {
                                    wp_kses_post( do_shortcode ( $bookstore_options['error404-title'] ) );
                                }
                                else {
                                    esc_html_e ( 'COMPONENT NOT FOUND.', 'bookstore' ); 
                                }
                                ?>
                            </h1>
                    </header><!-- .entry-header -->
                    <div class="entry-content">

                        <p>
                            <?php 
                                if(isset($bookstore_options['error404-desc'])) {
                                    wp_kses_post( do_shortcode( $bookstore_options['error404-desc'] ));
                                }
                                else {
                                    esc_html_e ( 'PLEASE USE SEARCH FORM:', 'bookstore' ); 
                                }
                                ?>
                        </p>

                        <a class="btn btn-home" href="<?php echo esc_url( home_url('/') ); ?>"><?php esc_html_e('Hompage', 'bookstore'); ?></a>

                    </div><!-- .entry-content -->
            </article>

    </div>
</div>


<?php get_footer(); 
