<?php

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "bookstore_settings";

    Redux::setExtensions( $opt_name, 'ReduxCore/inc/extensions/vendor_support'  );

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        'opt_name' => 'bookstore_settings',
        'use_cdn' => FALSE,
        'display_name' => 'Book Store',
        'display_version' => FALSE,
        'page_slug' => 'bookstore_settings',
        'page_title' => 'Book Store Settings',
        'update_notice' => false,
        'intro_text' => 'Book Store Settings',
        'footer_text' => 'Powered By AcmeeDesign',
        'menu_type' => 'menu',
        'menu_title' => 'BookStore',
        'allow_sub_menu' => false,
        'page_priority' => '5',
        'customizer' => TRUE,
        'default_mark' => '*',
        'class' => 'bookstore',
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        'disable_tracking' => true,
        'hints' => array(
            'icon' => 'el el-exclamation-sign',
            'icon_position' => 'right',
            'icon_color' => '#f4f4f4',
            'icon_size' => 'normal',
            'tip_style' => array(
                'color' => 'blue',
                'style' => 'bootstrap',
            ),
            'tip_position' => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect' => array(
                'show' => array(
                    'effect' => 'fade',
                    'duration' => '300',
                    'event' => 'mouseover',
                ),
                'hide' => array(
                    'effect' => 'fade',
                    'duration' => '500',
                    'event' => 'mouseleave unfocus',
                ),
            ),
        ),
        'output' => true,
        'output_tag' => false,
        'settings_api' => TRUE,
        'cdn_check_time' => '1440',
        'compiler' => false,
        'global_variable' => 'bookstore_options',
        'page_permissions' => 'manage_options',
        'save_defaults' => TRUE,
        'show_import_export' => TRUE,
        'disable_save_warn' => TRUE,
        'database' => 'options',
        'transient_time' => '3600',
        'network_sites' => TRUE,
        'async_typography'     => true,
        'dev_mode'  => false,
        'forced_dev_mode_off' => TRUE
    );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */



    /*
     *
     * ---> START SECTIONS
     *
     */

    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'General', 'bookstore' ),
        'id'     => 'general',
        'icon'   => 'el el-cog-alt',
    ) );

    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'General Settings', 'bookstore' ),
        'id'     => 'general_settings',
        'subsection' => true,
        'fields' => array(
            array(
                'id'       => 'layout_style',
                'type'     => 'select',
                'title'    => esc_html__( 'Layout style', 'bookstore' ),
                'subtitle' => esc_html__( 'Select style for the site. ', 'bookstore' ),
                'options'  => array(
                    'wide' => 'Wide',
                    'boxed' => 'Boxed',
                ),
                'default' => 'wide'
            ),
            array(
                'id'       => 'show_back_to_top',
                'type'     => 'checkbox',
                'title'    => esc_html__('Show Back to top button', 'bookstore'),
                'desc'     => esc_html__('Select to show Back to top button.', 'bookstore'),
                'default'  => '1'
            ),
            array(
                'id'       => 'body_bg_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Body background color', 'bookstore' ),
                'default'  => '#e5e5e5',
                'transparent'   => false,
            ),
            array(
                'id'       => 'body_bg_image',
                'type'     => 'media',
                'preview'  => true,
                'title'    => esc_html__( 'Upload background image', 'bookstore' ),
                'subtitle' => esc_html__( 'Body background image. ', 'bookstore' ),
            ),
            array(
                'id'       => 'body_image_repeat',
                'type'     => 'radio',
                'title'    => esc_html__( 'Body background repeat', 'bookstore' ),
                'subtitle' => esc_html__( 'Select body background image repeat type.', 'bookstore' ),
                'options'  => array(
                    'tiled' => 'Tiled',
                    'repeat-x' => 'Repeat X',
                    'repeat-y' => 'Repeat Y',
                    'full' => 'Full Size',
                ),
                'default' => 'tiled'
            ),
            array(
                'id'       => 'body_font_style',
                'type'        => 'typography',
                'title'       => esc_html__('Body Typography', 'bookstore'),
                'google'      => true,
                'font-backup' => true,
                'desc'     => esc_html__( 'Body typography settings.', 'bookstore' ),
                //'font-weight' => false,
                'font-style' => false,
                'default'     => array(
                    'color'       => '#666666',
                    'font-style'  => '300',
                    'font-family' => 'Roboto Slab',
                    'google'      => true,
                    'font-size'   => '15px',
                    'line-height' => '30'
                ),
            ),
            array(
                'id'       => 'heading_font_styles',
                'type'        => 'typography',
                'title'       => esc_html__('Heading Styles', 'bookstore'),
                'google'      => true,
                'font-backup' => true,
                'desc'     => esc_html__( 'Heading typography settings.', 'bookstore' ),
                'font-size' => false,
                'line-height' => false,
                'text-align' => false,
                'default'     => array(
                    'color'       => '#333333',
                    'font-style'  => '700',
                    'font-family' => 'Roboto Slab',
                    'google'      => true,
                ),
            ),

        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Page Settings', 'bookstore' ),
        'id'         => 'page-settings',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'page_header_bg_color',
                'type'     => 'color',
                'default'  => '#555555',
                'title'    => esc_html__( 'Background color', 'bookstore' ),
                'subtitle' => esc_html__( 'Background color for pages header. ', 'bookstore' ),
                'validate' => 'color',
                'transparent'   => false,
            ),
            array(
                'id'       => 'page_header_image',
                'type'     => 'media',
                'preview'  => true,
                'title'    => esc_html__( 'Upload background image', 'bookstore' ),
                'subtitle' => esc_html__( 'Upload background image for pages header. ', 'bookstore' ),
            ),
            array(
                'id'       => 'error404-title',
                'type'     => 'text',
                'title'    => esc_html__( '404 heading', 'bookstore' ),
                'desc'     => esc_html__( '404 page heading.', 'bookstore' ),
                'default'  => 'COMPONENT NOT FOUND.',
            ),
            array(
                'id'       => 'error404-desc',
                'type'     => 'textarea',
                'title'    => esc_html__( '404 description', 'bookstore' ),
                'desc'     => esc_html__( '404 page description.', 'bookstore' ),
                'default'  => 'PLEASE TRY ONE OF THE FOLLOWING PAGES:',
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Color Settings', 'bookstore' ),
        'id'         => 'color_settings',
        'icon'   => 'el el-brush',
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Primary colors', 'bookstore' ),
        'id'         => 'primary_color_settings',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'primary_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Background color', 'bookstore' ),
                'subtitle' => esc_html__( 'Background color for buttons, elements, etc.', 'bookstore' ),
                'default'  => '#27ae61',
                'transparent'   => false,
            ),
            array(
                'id'       => 'primary_text_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Text color', 'bookstore' ),
                'subtitle' => esc_html__( 'Text color for buttons, elements, etc.', 'bookstore' ),
                'default'  => '#ffffff',
                'transparent'   => false,
            ),
            array(
                'id'       => 'primary_hover_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Background hover color', 'bookstore' ),
                'subtitle' => esc_html__( 'Background hover color for buttons, elements, etc.', 'bookstore' ),
                'default'  => '#229955',
                'transparent'   => false,
            ),
            array(
                'id'       => 'primary_text_hover_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Text hover color', 'bookstore' ),
                'subtitle' => esc_html__( 'Text hover color for buttons, elements, etc.', 'bookstore' ),
                'default'  => '#ffffff',
                'transparent'   => false,
            ),
            array(
                'id'       => 'anchor_text_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Read more text color', 'bookstore' ),
                'default'  => '#27ae61',
                'transparent'   => false,
            ),
            array(
                'id'       => 'anchor_text_hover_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Read more text hover color', 'bookstore' ),
                'default'  => '#229955',
                'transparent'   => false,
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Secondary colors', 'bookstore' ),
        'id'         => 'secondary_color_settings',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'secondary_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Background color', 'bookstore' ),
                'subtitle' => esc_html__( 'Background color for buttons, elements, etc.', 'bookstore' ),
                'default'  => '#ffffff',
                'transparent'   => false,
            ),
            array(
                'id'       => 'secondary_text_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Text color', 'bookstore' ),
                'subtitle' => esc_html__( 'Text color for buttons, elements, etc.', 'bookstore' ),
                'default'  => '#333333',
                'transparent'   => false,
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Header Settings', 'bookstore' ),
        'id'    => 'header-settings',
        'icon'  => 'el el-website',
    ) );

    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Top bar', 'bookstore' ),
        'id'    => 'top-bar',
        'subsection' => true,
        'fields' => array(
            array(
                'id'       => 'show_topbar',
                'type'     => 'checkbox',
                'title'    => esc_html__('Show Top bar', 'bookstore'),
                'desc'     => esc_html__('Select to show Top bar above header.', 'bookstore'),
                'default'  => '1'// 1 = on | 0 = off
            ),
            array(
                'id'       => 'topbar_bg_color',
                'type'     => 'color',
                'title'    => esc_html__('Top bar background', 'bookstore'),
                'desc'     => esc_html__('Choose Top bar background color.', 'bookstore'),
                'default'  => '#F5F5F5',
                'transparent'   => false,
            ),
            array(
                'id'       => 'topbar_text_color',
                'type'     => 'color',
                'title'    => esc_html__('Top bar text color', 'bookstore'),
                'desc'     => esc_html__('Choose Top bar text color.', 'bookstore'),
                'default'  => '#999999',
                'transparent'   => false,
            ),
            array(
                'id'       => 'topbar_link_color',
                'type'     => 'link_color',
                'title'    => esc_html__('Top bar link color', 'bookstore'),
                'desc'     => esc_html__('Choose Top bar link color.', 'bookstore'),
                'default'  => array(
                    'regular'  => '#999999',
                    'hover'    => '#27ae61',
                    'active'   => '#27ae61',
                    'visited'  => '#27ae61',
                ),
            ),
            array(
                'id'       => 'topbar_menu_border_color',
                'type'     => 'color',
                'title'    => esc_html__('Top bar menu border color', 'bookstore'),
                'desc'     => esc_html__('Choose Top bar menu border color.', 'bookstore'),
                'default'  => '#27ae61',
                'transparent'   => false,
            ),
            array(
                'id'       => 'topbar_icons_color',
                'type'     => 'color',
                'title'    => esc_html__('Top bar icons color', 'bookstore'),
                'desc'     => esc_html__('Choose Top bar icons color.', 'bookstore'),
                'default'  => '#27ae61',
                'transparent'   => false,
            ),
            array(
                'id'               => 'header_topbar_content',
                'type'             => 'editor',
                'title'            => esc_html__('Top bar Content', 'bookstore'),
                'subtitle'         => esc_html__('Header Top bar content.', 'bookstore'),
                'default'          => 'Call: + 0123 456 789',
                'args'   => array(
                    'teeny'            => true,
                    'textarea_rows'    => 10
                ),
            ),

        )
    ) );

    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Header', 'bookstore' ),
        'id'    => 'header',
        'subsection' => true,
        'fields' => array(
            array(
                'id'       => 'site_logo',
                'type'     => 'media',
                'preview'  => true,
                'title'    => esc_html__( 'Upload Logo', 'bookstore' ),
                'subtitle' => esc_html__( 'Upload logo for header. ', 'bookstore' ),
            ),
            array(
                'id'       => 'header_bg_color',
                'type'     => 'color',
                'title'    => esc_html__('Header background color', 'bookstore'),
                'desc'     => esc_html__('Choose header background color.', 'bookstore'),
                'default'  => '#ffffff',
                'transparent'   => false,
            ),

        )
    ) );

    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Currency Switcher', 'bookstore' ),
        'id'    => 'currency-switcher',
        'subsection' => true,
        'fields' => array(
            array(
                'id'       => 'currency_switcher',
                'type'     => 'checkbox',
                'title'    => esc_html__('Show Currency Switcher', 'bookstore'),
                'desc'     => esc_html__('Select to show Currency Switcher on header.', 'bookstore'),
                'default'  => '0'// 1 = on | 0 = off
            ),
            array(
                'id'       => 'currency_bg_color',
                'type'     => 'color',
                'title'    => esc_html__('Background color', 'bookstore'),
                'desc'     => esc_html__('Choose currency switcher background color.', 'bookstore'),
                'default'  => '#ffffff',
                'transparent'   => false,
            ),
            array(
                'id'       => 'currency_border_color',
                'type'     => 'color',
                'title'    => esc_html__('Border color', 'bookstore'),
                'desc'     => esc_html__('Choose currency switcher border color.', 'bookstore'),
                'default'  => '#e4e4e4',
                'transparent'   => false,
            ),
            array(
                'id'       => 'currency_text_color',
                'type'     => 'link_color',
                'title'    => esc_html__('Text color', 'bookstore'),
                'desc'     => esc_html__('Choose currency switcher text color.', 'bookstore'),
                'default'  => array(
                    'regular'  => '#323232',
                    'hover'    => '#27ae61',
                ),
                'hover' => false,
                'visited'   => false,
            ),
            array(
                'id'       => 'currency_drop_bg_color',
                'type'     => 'color',
                'title'    => esc_html__('Drop down color', 'bookstore'),
                'desc'     => esc_html__('Choose drop down background color.', 'bookstore'),
                'default'  => '#ffffff',
                'transparent'   => false,
            ),
            array(
                'id'       => 'currency_drop_hover_bg_color',
                'type'     => 'color',
                'title'    => esc_html__('Drop down hover color', 'bookstore'),
                'desc'     => esc_html__('Choose drop down hover background color.', 'bookstore'),
                'default'  => '#27ae61',
                'transparent'   => false,
            ),
            array(
                'id'       => 'currency_drop_text_color',
                'type'     => 'link_color',
                'title'    => esc_html__('Drop down text color', 'bookstore'),
                'desc'     => esc_html__('Choose drop down text color.', 'bookstore'),
                'default'  => array(
                    'regular'  => '#323232',
                    'hover'    => '#ffffff',
                ),
                'active' => false,
                'visited'   => false,
            ),

        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Slider Settings', 'bookstore' ),
        'id'         => 'slider-settings',
        'icon'  => 'el el-picture',
        'fields'     => array(
            array(
                'id'       => 'show_revslider',
                'type'     => 'checkbox',
                'title'    => esc_html__( 'Show Revolution slider on homepage.', 'bookstore' ),
                'default'  => '1'
            ),
            array(
                'id'       => 'slider_alias',
                'type'     => 'text',
                'title'    => esc_html__( 'Slider Alias', 'bookstore' ),
                'subtitle'  => esc_html__( 'Enter slider alias. Ex: slider1', 'bookstore' ),
                'desc'     => "<a target='_blank' href='http://www.themepunch.com/revslider-doc/first-steps/'>" . esc_html__('For details about creating slider alias: Check this article.', 'bookstore' ) . "</a>",
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Menu Settings', 'bookstore' ),
        'id'         => 'bks-menu-settings',
        'icon'  => 'el el-lines',
        'fields'     => array(
            array(
                'id'       => 'main_menu_fonts',
                'type'        => 'typography',
                'title'       => esc_html__('Main Menu Typography', 'bookstore'),
                'google'      => true,
                'font-backup' => true,
                'color'       => false,
                'font-style'    => false,
                //'font-weight'   => false,
                'desc'     => esc_html__( 'Top level menu typography settings.', 'bookstore' ),
                'default'     => array(
                    'color'       => '#fff',
                    'font-weight'  => '400',
                    'font-family' => 'Roboto Slab',
                    'google'      => true,
                    'font-size'   => '13px',
                    'line-height' => '30'
                ),
            ),
            array(
                'id'       => 'menu_link_colors',
                'type'     => 'link_color',
                'title'    => esc_html__('Main menu link colors', 'bookstore'),
                'desc'     => esc_html__('Choose Main menu link colors.', 'bookstore'),
                'default'  => array(
                    'regular'  => '#ffffff',
                    'hover'    => '#ffffff',
                    'active'   => '#ffffff',
                ),
            ),
            array(
                'id'       => 'top_menu_bg_color',
                'type'     => 'color',
                'default'  => '#27ae61',
                'title'    => esc_html__( 'Top Menu background color', 'bookstore' ),
                'subtitle' => esc_html__( 'Background color for Top level menu. ', 'bookstore' ),
                'validate' => 'color',
                'transparent'   => false,
            ),
            array(
                'id'       => 'menu_hover_type',
                'type'     => 'radio',
                'title'    => esc_html__( 'Menu hover type', 'bookstore' ),
                'subtitle' => esc_html__( 'Select menu hover type. ', 'bookstore' ),
                'options'  => array(
                    '1' => 'Background color',
                    '2' => 'Underline',
                ),
                'default' => '1'
            ),
            array(
                'id'       => 'top_menu_hover_bg_color',
                'type'     => 'color',
                'default'  => '#229955',
                'title'    => esc_html__( 'Top Menu hover background color', 'bookstore' ),
                'subtitle' => esc_html__( 'Hover background color for Top level menu. ', 'bookstore' ),
                'validate' => 'color',
                'transparent'   => false,
                'required' => array('menu_hover_type','equals','1')
            ),
            array(
                'id'       => 'top_menu_active_bg_color',
                'type'     => 'color',
                'default'  => '#229955',
                'title'    => esc_html__( 'Top Menu Active background color', 'bookstore' ),
                'subtitle' => esc_html__( 'Active background color for Top level menu. ', 'bookstore' ),
                'validate' => 'color',
                'transparent'   => false,
                'required' => array('menu_hover_type','equals','1')
            ),
            array(
                'id'       => 'top_menu_border_color',
                'type'     => 'color',
                'default'  => '#ffffff',
                'title'    => esc_html__( 'Border color', 'bookstore' ),
                'subtitle' => esc_html__( 'Border color for Top level menu. ', 'bookstore' ),
                'validate' => 'color',
                'transparent'   => false,
                'required' => array('menu_hover_type','equals','2')
            ),
            array(
                'id'       => 'sub_menu_bg_color',
                'type'     => 'color',
                'default'  => '#ffffff',
                'title'    => esc_html__( 'Mega Menu (Sub level)', 'bookstore' ),
                'subtitle' => esc_html__( 'Mega Menu background color. ', 'bookstore' ),
                'validate' => 'color',
                'transparent'   => false,
            ),
            array(
                'id'       => 'sub_menu_color',
                'type'     => 'color',
                'default'  => '#262626',
                'title'    => esc_html__( 'Mega Menu link color', 'bookstore' ),
                'subtitle' => esc_html__( 'Mega Menu link color. ', 'bookstore' ),
                'validate' => 'color',
                'transparent'   => false,
            ),
            array(
                'id'       => 'sub_menu_hover_color',
                'type'     => 'color',
                'default'  => '#27ae61',
                'title'    => esc_html__( 'Mega Menu link hover color', 'bookstore' ),
                'subtitle' => esc_html__( 'Mega Menu link hover color. ', 'bookstore' ),
                'validate' => 'color',
                'transparent'   => false,
            ),
            array(
                'id'       => 'sub_menu_border_color',
                'type'     => 'color',
                'default'  => '#e5e5e5',
                'title'    => esc_html__( 'Mega Menu border color', 'bookstore' ),
                'subtitle' => esc_html__( 'Mega Menu border color. ', 'bookstore' ),
                'validate' => 'color',
                'transparent'   => false,
            ),
            array(
                'id'       => 'enable_search_on_menu',
                'type'     => 'checkbox',
                'title'    => esc_html__( 'Show search box', 'bookstore' ),
                'default'  => '0',
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Shop Settings', 'bookstore' ),
        'id'         => 'bks-shop-settings',
        'icon'  => 'el el-shopping-cart-sign',
        'fields'     => array(
            array(
                'id'       => 'shop-title',
                'type'     => 'text',
                'title'    => esc_html__( 'Shop title', 'bookstore' ),
                'desc'     => esc_html__( 'Shop title for shop archive.', 'bookstore' ),
                'default'  => 'Shop',
            ),
            array(
                'id'       => 'shop_header_bg_color',
                'type'     => 'color',
                'default'  => '#e5e5e5',
                'title'    => esc_html__( 'Shop background color', 'bookstore' ),
                'subtitle' => esc_html__( 'Background color for shop header. ', 'bookstore' ),
                'validate' => 'color',
                'transparent'   => false,
            ),
            array(
                'id'       => 'shop_header_bg_img',
                'type'     => 'media',
                'preview'  => true,
                'title'    => esc_html__( 'Shop header background image', 'bookstore' ),
                'subtitle' => esc_html__( 'Upload background image for shop header. ', 'bookstore' ),
            ),
            array(
                'id'       => 'shop_sidebar_position',
                'type'     => 'radio',
                'title'    => esc_html__( 'Shop sidebar position', 'bookstore' ),
                'subtitle' => esc_html__( 'Select sidebar position for shop page. ', 'bookstore' ),
                'options'  => array(
                    'left' => 'On left',
                    'right' => 'On right',
                ),
                'default' => 'left'
            ),
            array(
                'id'       => 'show_author_link_single_product',
                'type'     => 'checkbox',
                'title'    => esc_html__( 'Show author link', 'bookstore' ),
                'subtitle' => esc_html__( 'Show author link on single product page under product price. ', 'bookstore' ),
                'default'  => '0',
            ),
            array(
                'id'       => 'shop_products_count',
                'type'     => 'slider',
                'title'    => esc_html__( 'Number of products', 'bookstore' ),
                'desc'     => esc_html__( 'Number of products to show shop page.', 'bookstore' ),
                'default'  => '12',
                "min"       => 1,
                "step"      => 1,
                "max"       => 100,
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Blog Settings', 'bookstore' ),
        'id'         => 'bks-blog-settings',
        'icon'  => 'el el-pencil-alt',
        'fields'     => array(
            array(
                'id'       => 'blog_header_bg_color',
                'type'     => 'color',
                'default'  => '#555555',
                'title'    => esc_html__( 'Blog header background color', 'bookstore' ),
                'subtitle' => esc_html__( 'Cackground color for blog header. ', 'bookstore' ),
                'validate' => 'color',
                'transparent'   => false,
            ),
            array(
                'id'       => 'blog_header_bg_img',
                'type'     => 'media',
                'preview'  => true,
                'title'    => esc_html__( 'Blog header background image', 'bookstore' ),
                'subtitle' => esc_html__( 'Upload background image for blog header. ', 'bookstore' ),
            ),
            array(
                'id'       => 'blog_sidebar_position',
                'type'     => 'radio',
                'title'    => esc_html__( 'Blog sidebar position', 'bookstore' ),
                'subtitle' => esc_html__( 'Select sidebar position for blog page. ', 'bookstore' ),
                'options'  => array(
                    'left' => 'On left',
                    'right' => 'On right',
                ),
                'default' => 'left'
            ),
            array(
                'id'       => 'show_author_bio',
                'type'     => 'checkbox',
                'title'    => esc_html__( 'Show author biography on single page', 'bookstore' ),
                'default'  => '1'
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Footer Settings', 'bookstore' ),
        'id'         => 'footer_settings',
        'icon'  => 'el el-photo',
        'fields'     => array(
            array(
                'id'       => 'logo_on_footer',
                'type'     => 'checkbox',
                'title'    => esc_html__( 'Show logo on footer', 'bookstore' ),
            ),
            array(
                'id'       => 'footer_logo',
                'type'     => 'media',
                'preview'  => true,
                'title'    => esc_html__( 'Upload Logo', 'bookstore' ),
                'subtitle' => esc_html__( 'Upload logo for footer. ', 'bookstore' ),
            ),
            array(
                'id'       => 'footer_copyright_text',
                'type'     => 'textarea',
                'title'    => esc_html__( 'Footer Copyright text', 'bookstore' ),
                'desc'     => esc_html__( 'Html contents are allowed.', 'bookstore' ),
                'default'  => 'Copyright 2016 ' . get_bloginfo('name')  . 'All Rights Reserved.',
            ),
            array(
                'id'       => 'footer_btm_right',
                'type'     => 'editor',
                'title'    => esc_html__( 'Footer bottom right content', 'bookstore' ),
                'desc'     => esc_html__( 'You can insert any information like payment modes.', 'bookstore' ),
                'default'  => 'All major Credit/debit cards will be accepted.',
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Promo Content', 'bookstore' ),
        'id'         => 'promo_content',
        'icon'  => 'el el-bulb',
        'desc'  =>  'Promo content show on all pages above footer area.',
        'fields'     => array(
            array(
                'id'       => 'promo_bg_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Background color', 'bookstore' ),
                'subtitle' => esc_html__( 'Background color for promo content area.', 'bookstore' ),
                'default'  => '#B7A930',
                'transparent'   => false,
            ),
            array(
                'id'       => 'promo_content',
                'type'     => 'editor',
                'title'    => esc_html__( 'Promo content', 'bookstore' ),
                'args'   => array(
                    'teeny' => false,
                    'textarea_rows' => 8,
               'tinymce' => array('toolbar2' => 'forecolor'),
                   // 'tinymce' => array('toolbar2' => 'formatselect,underline,alignjustify,forecolor,pastetext,removeformat,charmap,outdent,indent,undo,redo,wp_help'),
                ),
                'default'  => 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.',
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Social icons', 'bookstore' ),
        'id'         => 'social_icons_config',
        'icon'  => 'el el-share',
        'fields'     => array(
            array(
                'id'       => 's_icons_bg_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Background color', 'bookstore' ),
                'subtitle' => esc_html__( 'Icon background color.', 'bookstore' ),
                'default'  => '#24a9e2',
                'transparent'   => false,
            ),
            array(
                'id'       => 's_icons_bg_hover_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Background hover color', 'bookstore' ),
                'subtitle' => esc_html__( 'Icon background hover color.', 'bookstore' ),
                'default'  => '#1e73be',
                'transparent'   => false,
            ),
            array(
                'id'       => 's_icons_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Icon color', 'bookstore' ),
                'subtitle' => esc_html__( 'Icon color.', 'bookstore' ),
                'default'  => '#ffffff',
                'transparent'   => false,
            ),
            array(
                'id'       => 's_icons_hover_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Icon hover color', 'bookstore' ),
                'subtitle' => esc_html__( 'Icon hover color.', 'bookstore' ),
                'default'  => '#ffffff',
                'transparent'   => false,
            ),
            array(
                'id'       => 's_icons_type',
                'type'     => 'radio',
                'title'    => esc_html__('Icon type', 'bookstore'),
                'options'  => array(
                    '1' => 'Circle',
                    '2' => 'Square',
                ),
                'default' => '1',
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Custom CSS', 'bookstore' ),
        'id'         => 'custom_css',
        'icon'  => 'el el-italic',
        'fields'     => array(
            array(
                'id'       => 'bookstore_custom_css',
                'type'     => 'ace_editor',
                'mode'  => 'css',
                'theme'=> 'monokai',
                'title'    => esc_html__( 'Custom CSS', 'bookstore' ),
                'desc'     => esc_html__( "Custom css will override the theme's styles.", 'bookstore' ),
            ),
        )
    ) );

    /*
     * <--- END SECTIONS
     */
