<?php
/**
 * The template for displaying comments
 *
 * The area of the page that contains both current comments
 * and the comment form.
 *
 * @package bookstore
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-area">

    <?php if ( have_comments() ) : ?>
            <h3 class="comments-title">
                    <?php
                            printf( _nx( '1 comment', '%1$s comments', get_comments_number(), 'comments title', 'bookstore' ),
                                    number_format_i18n( get_comments_number() ), get_the_title() );
                    ?>
            </h3>

            <ol class="comment-list">
                    <?php
                            bookstore_list_blog_comments();
                    ?>
            </ol><!-- .comment-list -->

            <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
                <nav class="comment-navigation" role="navigation">
                        <h1 class="screen-reader-text"><?php esc_html_e ( 'Comment navigation', 'bookstore' ); ?></h1>
                        <div class="nav-previous"><?php previous_comments_link( esc_html__( 'Older Comments', 'bookstore' ) ); ?></div>
                        <div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments', 'bookstore' ) ); ?></div>
                </nav><!-- #comment-navigation -->
            <?php endif;  ?>

    <?php endif; // have_comments() ?>

    <?php
            // If comments are closed and there are comments, let's leave a little note, shall we?
            if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
    ?>
            <p class="no-comments"><?php esc_html_e ( 'Comments are closed.', 'bookstore' ); ?></p>
    <?php endif; ?>

            <div class="clearfix">
                <?php 

                $commenter = wp_get_current_commenter();
                $req = get_option( 'require_name_email' );
                $aria_req = ( $req ? " aria-required='true'" : '' );

                $fields  =  array(

              'author' =>
                '<p class="comment-form-author"><label for="author">' . esc_html__( 'Name', 'bookstore' ) . ( $req ? '<span class="required"> *</span>' : '' ) . '</label> ' .

                '<input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) .
                '" size="30"' . $aria_req . ' placeholder="' . esc_html__('enter your name...', 'bookstore') . '" /></p>',

              'email' =>
                '<p class="comment-form-email"><label for="email">' . esc_html__( 'Email', 'bookstore' ) . ( $req ? '<span class="required"> *</span>' : '' ) . '</label> ' .
                '<input id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) .
                '" size="30"' . $aria_req . ' placeholder="' . esc_html__('enter your e-mail address...', 'bookstore') . '" /></p>',

              'url' =>
                '<p class="comment-form-url"><label for="url">' . esc_html__( 'Website URL', 'bookstore' ) . '</label>' .
                '<input id="url" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) .
                '" size="30" placeholder="' . esc_html__('enter your website URL...', 'bookstore') . '" /></p>',
            );
                $args = array(
                    'comment_field' => '<p class="comment-form-comment"><label for="comment">' . esc_html__( 'Message', 'bookstore' ) .
                    '</label><textarea id="comment" name="comment" rows="20" col="10" aria-required="true" placeholder="' . esc_html__('enter your message here...', 'bookstore') . '"></textarea></p>',
                    'fields' => apply_filters( 'comment_form_default_fields', $fields ),
                    'label_submit'      => esc_html__( 'Submit Comment', 'bookstore' ),
                    'class_submit'      => 'btn btn-primary',
                );
                comment_form($args); 

                ?>
            </div><!-- .clearfix -->
</div><!-- .comments-area -->
