<?php
/**
 * The default template for displaying content
 * Used for both single and index/archive/search.
 * 
 * @package   bookstore
 * @author    AcmeeDesign
 * @link      http://acmeedesign.com
 * @since     1.0
 */
?>

<?php $get_post_format = get_post_format(); ?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    
    <header class="entry-header">
            <?php
            if( $get_post_format == 'video' ){
                    $get_video_url = get_post_meta($post->ID, '_post_video_url', true);
                    if( !empty($get_video_url) ){
                        if ( shortcode_exists( 'video' ) ) {
                            echo do_shortcode("[video align='right' aspect_ratio='16:9' width='100' autoplay='0']" . esc_url($get_video_url) . "[/video]");
                        }
                        else { 
                            echo esc_url($get_video_url);
                        }
                    }
            }
            if( $get_post_format == 'audio' ){
                    $get_audio_url = get_post_meta($post->ID, '_post_audio_url', true);
                    if( !empty($get_audio_url) ){
                        $get_domain_name = bookstore_get_domain_name($get_audio_url);
                        $get_extension = bookstore_get_file_url_ext($get_audio_url);
                        
                        if($get_domain_name[0] == "soundcloud") {
                            if ( shortcode_exists( 'soundcloud' ) ) {
                                echo do_shortcode("[soundcloud]" . esc_url($get_audio_url) . "[/soundcloud]");
                            }
                            else {
                                echo esc_url($get_audio_url);
                            }
                        }
                        elseif( in_array($get_extension, array('mp3', 'ogg', 'wav')) ){
                            if ( shortcode_exists( 'audio' ) ) {
                                echo do_shortcode('[audio ' . esc_url($get_extension) . '="' . $get_audio_url . '"]');
                            }
                            else {
                                echo esc_url($get_extension);
                            }
                        }
                    }
            }
            if( $get_post_format == 'quote' ){
        ?>
        <blockquote class="blockquote">
            <?php if ( has_excerpt( $post->ID ) ) {
                the_excerpt();
            }
            else {
                the_content();
            }
            ?>
        </blockquote>
        <?php
            }
            elseif( $get_post_format != 'video' && $get_post_format != 'audio') {
                    if( has_post_thumbnail() ){
                            the_post_thumbnail('bookstore_blog_thumb', array('class' => 'img-responsive blog-thumbnail'));
                    }
            }
            ?>
        <div class="post-categories clearfix">
            <?php echo get_the_category_list(); ?>
        </div>
        
        <?php
        if( $get_post_format != 'quote' ) :
            if ( is_single() ) :
                                the_title( '<h1 class="entry-title">', '</h1>' );
                        else :
                                the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
                        endif;
        endif;
            ?>
        
        <div class="post-meta">
            <span class="author"><i class="fa fa-user"></i> <?php the_author(); ?></span>
            <span class="author"><i class="fa fa-calendar"></i> <?php echo get_the_date('l, d F Y'); ?></span>
            <span class="author"><i class="fa fa-comment"></i>
           <?php  comments_popup_link( esc_html__( 'Be the first to comment!', 'bookstore' ), esc_html__( '1 comment', 'bookstore' ), esc_html__( '% comments', 'bookstore' ) ); ?>
            </span>
        </div>
        
    </header><!-- .entry-header -->

    <?php if( $get_post_format != 'quote' ) : ?>
    
    <div class="entry-content">
        <div class="post-excerpt">
            <?php
                   bookstore_custom_excerpt(29);
            ?>
        </div>
    </div><!-- .entry-content -->

    <footer class="entry-footer">
        <a class="btn-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read More', 'bookstore'); ?></a>
    </footer><!-- .entry-footer -->

    <?php endif; ?>
    
</article><!-- #post-## -->
