<?php
/*
 * @package   bookstore
 * @author    AcmeeDesign
 * @link      http://acmeedesign.com
 * @since     1.0
 */

$bookstore_options = (function_exists('bookstore_options')) ? bookstore_options() : "";

?>
<?php if($bookstore_options['show_back_to_top'] == 1) { ?>
<!-- Back to Top -->
    <div id="back-to-top" data-spy="affix" data-offset-top="300" class="back-to-top hidden-xs hidden-sm affix">
      <button class="btn btn-primary" title="Back to Top"><i class="fa fa-arrow-up"></i></button>
    </div>
<!-- Back to Top -->
<?php } ?>

<?php
$is_enabled_promo = get_post_meta(get_the_ID(), '_enable_promo_content', true);
if($is_enabled_promo == 1) {
?>
<div class="vc_row wpb_row vc_row-fluid bks-promo">
    <div class="page-container">
        <div class="wpb_column vc_column_container vc_col-sm-12">
            <div class="vc_column-inner ">
                <div class="wpb_wrapper">
                    <div class="bks-promo-content col-md-8 col-md-offset-2">
                        <?php echo wp_kses_post( do_shortcode($bookstore_options['promo_content']) ); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
}
?>

<!-- FOOTER -->
      <footer id="bks-footer" class="wrap bks-footer">
         <!-- FOOT NAVIGATION -->
         <div class="footer-nav">
            <div class="container">
               <!-- SPOTLIGHT -->
               <div class="bks-spotlight bks-footnav row">

                  <?php if ( is_active_sidebar( 'footer-col1' ) || !empty($bookstore_options['footer_logo']['url']) ) : ?>
                  <div class=" col-lg-3 col-md-3 col-sm-6 col-xs-12">
                      <?php  if(isset($bookstore_options['logo_on_footer']) && $bookstore_options['logo_on_footer'] == 1 && isset($bookstore_options['footer_logo'])) { ?>
                      <div class="widget bks-module">
                           <a href="<?php echo esc_url( home_url('/') ); ?>" title="<?php echo bloginfo('name'); ?>">
                               <img class="logo-img" src="<?php  if(isset($bookstore_options['footer_logo'])) echo esc_url($bookstore_options['footer_logo']['url']); ?>" alt="<?php echo bloginfo('name'); ?>" />
                           </a>
                      </div>
                       <?php }

                       dynamic_sidebar('footer-col1'); ?>
                  </div>
                   <?php endif; ?>

                  <?php if ( is_active_sidebar( 'footer-col2' ) ) : ?>
                  <div class=" col-lg-3 col-md-3 col-sm-6 col-xs-12">
                       <?php dynamic_sidebar('footer-col2'); ?>
                  </div>
                   <?php endif; ?>

                   <?php if ( is_active_sidebar( 'footer-col3' ) ) : ?>
                  <div class=" col-lg-3 col-md-3 col-sm-6 col-xs-12">
                       <?php dynamic_sidebar('footer-col3'); ?>
                  </div>
                   <?php endif; ?>

                   <?php if ( is_active_sidebar( 'footer-col4' ) ) : ?>
                  <div class=" col-lg-3 col-md-3 col-sm-6 col-xs-12">
                       <?php dynamic_sidebar('footer-col4'); ?>
                  </div>
                   <?php endif; ?>
               </div>
               <!-- SPOTLIGHT -->
            </div>
         </div>
         <!-- //FOOT NAVIGATION -->


         <div class="bks-copyright">
            <div class="container">
               <div class="row">
                  <!-- //COPYRIGHTS -->
                  <div class="col-md-6 col-sm-6 col-xs-12">
                     <div class="col-md-12 copyright">
                           <small><?php if(isset($bookstore_options['footer_copyright_text'])) echo wp_kses_post( do_shortcode($bookstore_options['footer_copyright_text']) ); ?></small>
                     </div>
                  </div>
                  <!-- Footer Right Content -->
                  <div class="col-md-6 col-sm-6 col-xs-11">
                     <div class="right">
                        <?php if(isset($bookstore_options['footer_btm_right'])) echo wp_kses_post( do_shortcode($bookstore_options['footer_btm_right']) ); ?>
                     </div>
                     <!-- Footer Right Content -->
                  </div>
               </div>
            </div>
         </div>
      </footer>
      <!-- //FOOTER -->

      </div>

      <?php wp_footer(); ?>

      </body>
      </html>
