<?php
/*
 * @package   bookstore
 * @author    AcmeeDesign
 * @link      http://acmeedesign.com
 * @since     1.0
 */

$bookstore_options = (function_exists('bookstore_options')) ? bookstore_options() : "";

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" />
    <link rel="profile" href="http://gmpg.org/xfn/11" />
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
    <?php
    wp_head();
    ?>
</head>
<body <?php body_class(); ?>>
    <div class="wrapper">

          <?php if(isset($bookstore_options['show_topbar']) && $bookstore_options['show_topbar'] == 1) : ?>
         <!-- TOPBAR -->
         <div id="topbar" class="topbar">
            <div class="container">
               <div class="row">
                  <div class="col-xs-12 col-sm-6 col-md-6 text-left header-address">
                        <?php if(!empty($bookstore_options['header_topbar_content'])) echo wp_kses_post( do_shortcode($bookstore_options['header_topbar_content']) ); ?>
                  </div>
                  <div class="col-xs-12 col-sm-6 col-md-6 text-right header-quick-links">
                        <?php $args = array(
                          'theme_location'  => 'topbar',
                          'container'       => 'ul',
                          'container_id'    => 'topbar-nav',
                          'menu_class'      => 'nav  nav-pills nav-stacked',
                          'menu_id'         => 'menu',
                          'echo'            => true,
                          'fallback_cb'     => false,
                          'depth'           => 0, );
                            wp_nav_menu($args);
                            ?>
                  </div>
               </div>
            </div>
         </div>
         <!-- //TOPBAR -->
         <?php endif; ?>

         <!-- HEADER -->
         <header id="header" class="header">
            <div class="container">
               <div class="row">
                  <!-- LOGO -->
                  <div class="col-xs-12 col-sm-6 col-lg-8 col-md-6 logo">
                     <div class="site-logo">
                        <a href="<?php echo esc_url( home_url('/') ); ?>" title="<?php echo bloginfo('name'); ?>">
                        <?php  if(!empty($bookstore_options['site_logo']['url'])) { ?>
                        <img class="logo-img" src="<?php  if(isset($bookstore_options['site_logo'])) echo esc_url($bookstore_options['site_logo']['url']); ?>" alt="<?php bloginfo('name'); ?>" />
                            <?php } else { ?>
                        <h1 class="site-title"><?php bloginfo('name'); ?></h1>
                        <small class="site-desc"><?php bloginfo('description'); ?></small>
                            <?php } ?>
                        </a>
                     </div>
                  </div>
                  <!-- //LOGO -->
                  <div class="col-xs-12 col-sm-3 col-md-3 col-lg-2">
                  </div>
                  <div class="col-xs-12 col-sm-6 col-md-6 col-lg-4">
                     <!-- bks-cart-widget -->
                     <div class="bks-cart-widget right">

                         <?php if(isset($bookstore_options['currency_switcher']) && $bookstore_options['currency_switcher'] == 1) : ?>
                        <div class="currency-switcher pull-left">
                           <?php
                          echo do_shortcode( '[woocs show_flags=0 width="100px" txt_type="code"]' );
                           ?>
                        </div>
                         <?php endif; ?>

                         <?php if ( class_exists( 'WooCommerce' ) ) { ?>
                        <div class="mini-cart pull-right">
                              <div class="minicart-button">
                                 <span class="cart-item-info jb-cart-section">
                                     <a href="<?php echo esc_url(bookstore_get_cart_url()); ?>"><?php esc_html_e('Cart', 'bookstore'); echo wp_kses_post('<i class="fa fa-shopping-bag"></i>'); ?></a>
                                 <?php echo wp_kses_post(bookstore_woo_cart_count()); ?>
                                 </span>
                              </div>
                        </div>
                         <?php } ?>
                     </div>
                     <!-- //bks-cart-widget -->

                     <div class="clear bks-header-widget right">
                       <?php
                       if(is_active_sidebar('header-sidebar')) {
                           dynamic_sidebar('header-sidebar');
                       }
                        ?>
                     </div>
                  </div>
               </div>
            </div>
         </header>
         <!-- //HEADER -->
         <!-- MAIN NAVIGATION -->
         <nav class="main-menu affix-top" data-spy="affix" data-offset-top="110">
            <div class="container">
            <?php
            $args = array(
                'theme_location'  => 'primary',
                'container'       => 'ul',
                'container_id'    => 'navigation',
                'menu_class'      => 'nav-menu',
                'menu_id'         => '',
                'echo'            => true,
                'fallback_cb'     => 'wp_page_menu',
                'depth'           => 0,
                );
            wp_nav_menu($args);
    ?>
                <?php
                if(isset($bookstore_options['enable_search_on_menu']) && $bookstore_options['enable_search_on_menu'] == 1) { ?>
                <div class="nav-search">
                    <?php  get_template_part( 'content', 'product-search-form' );  ?>
                </div>
                <?php } ?>
            </div>
         </nav>
         <!-- //MAIN NAVIGATION -->
<?php if( is_front_page() && isset($bookstore_options['show_revslider']) && $bookstore_options['show_revslider'] == 1 && !empty($bookstore_options['slider_alias'])) { ?>
         <!-- Slide show -->
         <div class="wrap jb-slideshow">
             <?php
             if(function_exists('putRevSlider')) {
                 putRevSlider($bookstore_options['slider_alias']);
             }
             else {
                 esc_html_e('Sorry! Revolution slider is not activated yet. Please install and activate Revolution slider.', 'bookstore');
             }
             ?>
         </div>
         <!-- End of Slide show -->
<?php }
