<?php
/* 
 * @package   bookstore
 * @author    AcmeeDesign
 * @link      http://acmeedesign.com
 * @since     1.0
 */

//Author details entry for testimonials
if (!function_exists('bookstore_add_meta_box_tsm')) {
    function bookstore_add_meta_box_tsm() {
            add_meta_box(
                    'tsm_author_details',
                    esc_html__ ( 'Author details', 'bookstore' ),
                    'bookstore_author_details_callback',
                    'bookstore_testmonials', 'normal', 'high'
            );
    }
}
add_action( 'add_meta_boxes', 'bookstore_add_meta_box_tsm' );

/**
 * Prints the box content.
 * 
 * @param WP_Post $post The object for the current post/page.
 */
if (!function_exists('bookstore_author_details_callback')) {
    function bookstore_author_details_callback( $post ) {

            // Add a nonce field so we can check for it later.
            wp_nonce_field( 'bookstore_tsm_save_meta', 'bookstore_tsm_meta_box_nonce' );

            $author_name = get_post_meta( $post->ID, '_tsm_author_name', true );
            $author_company = get_post_meta( $post->ID, '_tsm_author_company', true );
    ?>
            <div class="author_name"><strong>
            <?php esc_html_e( 'Author name', 'bookstore' ); ?>
            </strong></div>
            <input type="text" id="author_name" name="author_name" value="<?php echo esc_attr( $author_name ); ?>" size="25" /><br /><br />
        <div class="author_company"><strong>
            <?php esc_html_e( 'Company', 'bookstore' ); ?>
            </strong></div>
            <input type="text" id="author_company" name="author_company" value="<?php echo esc_attr( $author_company ); ?>" size="25" /><br />
            <?php
    }
}

if (!function_exists('bookstore_author_details_save')) {
    function bookstore_author_details_save( $post_id ) {

            // Check if our nonce is set.
            if ( ! isset( $_POST['bookstore_tsm_meta_box_nonce'] ) ) {
                            return;
            }

            // Verify that the nonce is valid.
            if ( ! wp_verify_nonce( $_POST['bookstore_tsm_meta_box_nonce'], 'bookstore_tsm_save_meta' ) ) {
                            return;
            }

            // If this is an autosave, our form has not been submitted, so we don't want to do anything.
            if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
                            return;
            }

            // Check the user's permissions.
            if ( isset( $_POST['post_type'] ) && 'bookstore_testmonials' == $_POST['post_type'] ) {

                                if ( ! current_user_can( 'edit_page', $post_id ) ) {
                                        return;
                                }

            } else {

                                if ( ! current_user_can( 'edit_post', $post_id ) ) {
                                        return;
                                }
            }

            // Sanitize user input.
            $author_name = sanitize_text_field( $_POST['author_name'] );
            $author_company = sanitize_text_field( $_POST['author_company'] );

            // Update the meta field in the database.
            update_post_meta( $post_id, '_tsm_author_name', $author_name );
            update_post_meta( $post_id, '_tsm_author_company', $author_company );
    }
}
add_action( 'save_post', 'bookstore_author_details_save' );

if (!function_exists('bookstore_add_meta_box_audio_video_urls')) {
    function bookstore_add_meta_box_audio_video_urls() {
            add_meta_box(
                    'post_audio_video_urls',
                    esc_html__ ( 'Audio/Video URL', 'bookstore' ),
                    'bookstore_audio_video_urls_callback',
                    'post', 'normal', 'high'
            );
    }
}
add_action( 'add_meta_boxes', 'bookstore_add_meta_box_audio_video_urls' );

/**
 * Prints the box content.
 * 
 * @param WP_Post $post The object for the current post/page.
 */
if (!function_exists('bookstore_audio_video_urls_callback')) {
    function bookstore_audio_video_urls_callback( $post ) {

            // Add a nonce field so we can check for it later.
            wp_nonce_field( 'bookstore_audio_video_save_meta', 'bookstore_audio_video_meta_box_nonce' );

            $post_audio_url = get_post_meta( $post->ID, '_post_audio_url', true );
            $post_video_url = get_post_meta( $post->ID, '_post_video_url', true );
    ?>
            <div class="post_audio_url"><strong>
            <?php esc_html_e( 'Audio url', 'bookstore' ); ?>
            </strong></div>
            <input type="text" id="author_name" name="post_audio_url" value="<?php echo esc_attr( $post_audio_url ); ?>" size="25" /><br /><br />
                  <div class="post_video_url"><strong>
            <?php esc_html_e( 'Video url', 'bookstore' ); ?>
            </strong></div>
            <input type="text" id="post_video_url" name="post_video_url" value="<?php echo esc_attr( $post_video_url ); ?>" size="25" /><br />
    <?php
        }
}

if (!function_exists('bookstore_audio_video_urls_save')) {
    function bookstore_audio_video_urls_save( $post_id ) {

            // Check if our nonce is set.
            if ( ! isset( $_POST['bookstore_audio_video_meta_box_nonce'] ) ) {
                            return;
            }

            // Verify that the nonce is valid.
            if ( ! wp_verify_nonce( $_POST['bookstore_audio_video_meta_box_nonce'], 'bookstore_audio_video_save_meta' ) ) {
                            return;
            }

            // If this is an autosave, our form has not been submitted, so we don't want to do anything.
            if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
                            return;
            }

            // Check the user's permissions.
            if ( isset( $_POST['post_type'] ) && 'post' == $_POST['post_type'] ) {

                                if ( ! current_user_can( 'edit_page', $post_id ) ) {
                                        return;
                                }

            } else {

                                if ( ! current_user_can( 'edit_post', $post_id ) ) {
                                        return;
                                }
            }

            // Sanitize user input.
            $post_audio_url = sanitize_text_field( $_POST['post_audio_url'] );
            $post_video_url = sanitize_text_field( $_POST['post_video_url'] );

            // Update the meta field in the database.
            update_post_meta( $post_id, '_post_audio_url', $post_audio_url );
            update_post_meta( $post_id, '_post_video_url', $post_video_url );
    }
}
add_action( 'save_post', 'bookstore_audio_video_urls_save' );

if (!function_exists('bookstore_add_meta_box_promo')) {
    function bookstore_add_meta_box_promo() {
            add_meta_box(
                    'promo_content',
                    esc_html__ ( 'Promo content', 'bookstore' ),
                    'bookstore_promo_content_callback',
                    'page', 'normal', 'high'
            );
    }
}
add_action( 'add_meta_boxes', 'bookstore_add_meta_box_promo' );

if (!function_exists('bookstore_promo_content_callback')) {
    function bookstore_promo_content_callback( $post ) {

            // Add a nonce field so we can check for it later.
            wp_nonce_field( 'bookstore_promo_save_meta', 'bookstore_promo_meta_box_nonce' );

            $enable_promo = get_post_meta( $post->ID, '_enable_promo_content', true );
    ?>
            <div class="enable_promo" style="padding:10px;"><strong>
            <?php esc_html_e( 'Enable promo content', 'bookstore' ); ?>
            </strong><br />
            <input type="checkbox" id="enable_promo" name="enable_promo" value="1" <?php if($enable_promo == 1) { ?> checked="checked" <?php } ?> />
            <?php esc_html_e( 'Select to show promo content for this page.', 'bookstore'); ?>
            </div>
    <?php
        }
}

if (!function_exists('bookstore_promo_cotent_save')) {
    function bookstore_promo_cotent_save( $post_id ) {

            // Check if our nonce is set.
            if ( ! isset( $_POST['bookstore_promo_meta_box_nonce'] ) ) {
                            return;
            }

            // Verify that the nonce is valid.
            if ( ! wp_verify_nonce( $_POST['bookstore_promo_meta_box_nonce'], 'bookstore_promo_save_meta' ) ) {
                            return;
            }

            // If this is an autosave, our form has not been submitted, so we don't want to do anything.
            if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
                            return;
            }

            // Check the user's permissions.
            if ( isset( $_POST['post_type'] ) && 'page' == $_POST['post_type'] ) {

                                if ( ! current_user_can( 'edit_page', $post_id ) ) {
                                        return;
                                }

            } else {

                                if ( ! current_user_can( 'edit_post', $post_id ) ) {
                                        return;
                                }
            }

            // Sanitize user input.
            $is_enabled_promo = sanitize_text_field( $_POST['enable_promo'] );

            // Update the meta field in the database.
            update_post_meta( $post_id, '_enable_promo_content', $is_enabled_promo );
    }
}
add_action( 'save_post', 'bookstore_promo_cotent_save' );