<?php
/* 
 * @package   bookstore
 * @author    AcmeeDesign
 * @link      http://acmeedesign.com
 * @since     1.0
 */
    
    add_action( 'wp_enqueue_scripts', 'bookstore_vc_ext_scripts' );

    function bookstore_vc_ext_scripts(){
        //Registering required scripts
        wp_register_script( 'bookstore-owl-carousel', get_template_directory_uri() . '/assets/js/owl.carousel.min.js', array( 'jquery' ), '', true );
        wp_register_script( 'bookstore-lightslider', get_template_directory_uri() . '/assets/js/lightslider.min.js', array( 'jquery' ), '', true );
        wp_register_script( 'bookstore-slick-js', get_template_directory_uri() . '/assets/js/slick.min.js', array( 'jquery' ), '', true );        
        wp_register_script( 'bookstore-script-js', get_template_directory_uri() . '/assets/js/script.js', array( 'jquery' ), '', true );
        
        wp_enqueue_script ( 'jquery' );
        wp_enqueue_script("bookstore-owl-carousel");
        wp_enqueue_script("bookstore-lightslider");
        wp_enqueue_script("bookstore-slick-js");
        wp_enqueue_script("bookstore-script-js");        
    }    

    function bookstore_showVc_required() {
        $theme_name = wp_get_theme();
        echo '
        <div class="updated">
          <p>' . esc_html__('Bookstore theme requires, Visual Composer plugin to be installed and activated on your site.', 'bookstore')  . '</p>
        </div>';
    }

    add_action( 'vc_before_init', 'bookstore_shortcodes' );

    function bookstore_shortcodes() {
        // Check if Visual Composer is installed
        if ( ! defined( 'WPB_VC_VERSION' ) ) {
            // Display notice that Visual Compser is required
            add_action( 'admin_notices', 'bookstore_showVc_required' );
            return;
        }
        
        vc_set_as_theme();

    global $VISUAL_COMPOSER_EXTENSIONS;
    
    /*
     *  VC BKS Custom Heading
    */
    vc_map( array(
        "name" => esc_html__("BKS Heading", 'bookstore'),
        "description" => esc_html__("BKS Custom Heading.", 'bookstore'),
        "base" => "bksheading",
        "class" => "bks_heading",
        "controls" => "full",
        "icon" => "vc_navbar-brand",
        "category" => esc_html__('Bookstore', 'bookstore'),
        "params" => array(
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_heading_inputs",
              "heading" => esc_html__("Heading text", 'bookstore'),
              "param_name" => "heading_text",
              "description" => esc_html__("text for the heading.", 'bookstore')
          ),
            array(
              "type" => "textarea",
              "holder" => "div",
              "class" => "bks_heading_inputs",
              "heading" => esc_html__("Description", 'bookstore'),
              "param_name" => "description",
              "description" => esc_html__("Enter description.", 'bookstore')
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_heading_inputs",
              "heading" => esc_html__("Font size", 'bookstore'),
              "param_name" => "font_size",
              "description" => esc_html__("Enter font size.", 'bookstore')
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_heading_inputs",
              "heading" => esc_html__("Line height", 'bookstore'),
              "param_name" => "line_height",
              "description" => esc_html__("Enter line height.", 'bookstore')
          ),
            array(
              "type" => "colorpicker",
              "holder" => "div",
              "class" => "bks_heading_inputs",
              "heading" => esc_html__("Text color", 'bookstore'),
              "param_name" => "text_color",
              "description" => esc_html__("Select heading color", 'bookstore'),
          ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra class name', 'js_composer'),
                'param_name' => 'el_class',
                'description' => esc_html__('If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'js_composer')
          ),
        )
    ) );

    /*
     *  VC Image banner extension
    */
    vc_map( array(
        "name" => esc_html__("Image Banner", 'bookstore'),
        "description" => esc_html__("Image banner with text.", 'bookstore'),
        "base" => "bksbanner",
        "class" => "bks_banner",
        "controls" => "full",
        "icon" => "vc_navbar-brand", // or css class name which you can reffer in your css file later. Example: "vc_extend_my_class"
        "category" => esc_html__('Bookstore', 'bookstore'),
        //'admin_enqueue_js' => array(plugins_url('assets/vc_extend.js', __FILE__)), // This will load js file in the VC backend editor
        //'admin_enqueue_css' => array(plugins_url('assets/vc_extend_admin.css', __FILE__)), // This will load css file in the VC backend editor
        "params" => array(
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_banner_inputs",
              "heading" => esc_html__("Banner type", 'bookstore'),
              "param_name" => "banner_type",
               "value" => array('Select' => '', 'Image Background' => 'image_bg', 'Color Background' => 'color_bg'),
              "description" => esc_html__("Select Banner type.", 'bookstore')
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_banner_inputs",
              "heading" => esc_html__("Heading", 'bookstore'),
              "param_name" => "bn_heading",
              "value" => esc_html__("Banner heading", 'bookstore'),
              "description" => esc_html__("Heading to be shown over the banner.", 'bookstore')
          ),
            array(
              "type" => "textarea",
              "holder" => "div",
              "class" => "bks_banner_inputs",
              "heading" => esc_html__("Description", 'bookstore'),
              "param_name" => "bn_desc",
              "value" => esc_html__("Banner description", 'bookstore'),
              "description" => esc_html__("Description to be shown over the banner.", 'bookstore')
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_banner_inputs",
              "heading" => esc_html__("Link text.", 'bookstore'),
              "param_name" => "link_text",
              "description" => esc_html__("Link text to be shown over the banner.", 'bookstore')
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_banner_inputs",
              "heading" => esc_html__("URL (Link)", 'bookstore'),
              "param_name" => "bn_link",
              "description" => esc_html__("Banner url.", 'bookstore')
          ),
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_banner_inputs",
              "heading" => esc_html__("Text align", 'bookstore'),
              "param_name" => "textalign",
               "value" => array('left', 'right', 'center', 'justify'),
              "description" => esc_html__("Select text alignment.", 'bookstore')
          ),
            array(
              "type" => "colorpicker",
              "holder" => "div",
              "class" => "bks_banner_inputs",
              "heading" => esc_html__("Background color", 'bookstore'),
              "param_name" => "bg_color",
              "value" => '', 
              "description" => esc_html__("Choose background color", 'bookstore'),
              "dependency" => array('element' => 'banner_type', 'value' => 'color_bg')
          ),
          array(
              "type" => "colorpicker",
              "holder" => "div",
              "class" => "bks_banner_inputs",
              "heading" => esc_html__("Heading color", 'bookstore'),
              "param_name" => "head_color",
              "value" => '', 
              "description" => esc_html__("Choose text color", 'bookstore')
          ),
            array(
              "type" => "colorpicker",
              "holder" => "div",
              "class" => "bks_banner_inputs",
              "heading" => esc_html__("Description color", 'bookstore'),
              "param_name" => "desc_color",
              "value" => '', 
              "description" => esc_html__("Choose text color", 'bookstore')
          ),
            array(
              "type" => "colorpicker",
              "holder" => "div",
              "class" => "bks_banner_inputs",
              "heading" => esc_html__("Link color", 'bookstore'),
              "param_name" => "link_color",
              "value" => '', 
              "description" => esc_html__("Choose link text color", 'bookstore')
          ),
          array(
              "type" => "attach_image",
              "holder" => "div",
              "class" => "bks_banner_inputs",
              "heading" => esc_html__("Banner image", 'bookstore'),
              "param_name" => "img_for_banner",
              "description" => esc_html__("Attach image.", 'bookstore'),
              "dependency" => array('element' => 'banner_type', 'value' => 'image_bg')
          ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra class name', 'js_composer'),
                'param_name' => 'el_class',
                'description' => esc_html__('If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'js_composer')
          ),
        )
    ) );

     /*
     *  VC Feature box extension
    */
    vc_map( array(
        "name" => esc_html__("Feature box", 'bookstore'),
        "description" => esc_html__("BKS Feature box", 'bookstore'),
        "base" => "bks_fbox",
        "class" => "bks_feature_box",
        "controls" => "full",
        "icon" => "vc_navbar-brand", // or css class name which you can reffer in your css file later. Example: "vc_extend_my_class"
        "category" => esc_html__('Bookstore', 'bookstore'),
        "params" => array(
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("Feature box type", 'bookstore'),
              "param_name" => "f_style",
               "value" => array( 'Select' => '', 
                   'Rectangle box - default position' =>'style1', 
                   'Rectangle box over top element' => 'style2', 
                   //'Circle type' => 'style3'
                   ),
              "description" => esc_html__("Select box type.", 'bookstore')
          ),
            array(
              "type" => "colorpicker",
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("Feature box color", 'bookstore'),
              "param_name" => "fbox_color",
              "value" => '', 
              "description" => esc_html__("Choose box color", 'bookstore')
          ),
            array(
              "type" => "colorpicker",
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("Text color", 'bookstore'),
              "param_name" => "f_text_color",
              "value" => '', 
              "description" => esc_html__("Choose text color", 'bookstore')
          ),
            array(
              "type" => "colorpicker",
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("Link Text color", 'bookstore'),
              "param_name" => "f_link_color",
              "value" => '', 
              "description" => esc_html__("Choose link text color", 'bookstore'),
              "dependency" => array('element' => 'f_style', 'value' => 'style3')
          ),
            array(
              "type" => "colorpicker",
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("Icon color", 'bookstore'),
              "param_name" => "f_icon_color",
              "value" => '', 
              "description" => esc_html__("Choose Icon color", 'bookstore')
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("Heading for Feature item 1", 'bookstore'),
              "param_name" => "f_item_1_heading",
          ),
            array(
              "type" => "textarea",
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("Description for Feature item 1", 'bookstore'),
              "param_name" => "f_item_1_desc",
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("Link Text for Feature item 1", 'bookstore'),
              "param_name" => "f_link_text_1",
              "description" => esc_html__("Link text.", 'bookstore'),
              "dependency" => array('element' => 'f_style', 'value' => 'style3')
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("URL (Link) for Feature item 1", 'bookstore'),
              "param_name" => "f_link_1",
              "dependency" => array('element' => 'f_style', 'value' => 'style3')
          ),
            array(
              "type" => 'iconpicker',
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("Icon for Feature item 1", 'bookstore'),
              "param_name" => "f_icon_1",
              "description" => esc_html__("Choose Icon", 'bookstore')
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("Heading for Feature item 2", 'bookstore'),
              "param_name" => "f_item_2_heading",
          ),
            array(
              "type" => "textarea",
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("Description for Feature item 2", 'bookstore'),
              "param_name" => "f_item_2_desc",
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("Link Text for Feature item 2", 'bookstore'),
              "param_name" => "f_link_text_2",
              "description" => esc_html__("Link text.", 'bookstore'),
              "dependency" => array('element' => 'f_style', 'value' => 'style3')
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("URL (Link) for Feature item 2", 'bookstore'),
              "param_name" => "f_link_2",
              "dependency" => array('element' => 'f_style', 'value' => 'style3')
          ),
            array(
              "type" => 'iconpicker',
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("Icon for Feature item 2", 'bookstore'),
              "param_name" => "f_icon_2",
              "description" => esc_html__("Choose Icon", 'bookstore')
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("Heading for Feature item 3", 'bookstore'),
              "param_name" => "f_item_3_heading",
          ),
            array(
              "type" => "textarea",
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("Description for Feature item 3", 'bookstore'),
              "param_name" => "f_item_3_desc",
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("Link Text for Feature item 3", 'bookstore'),
              "param_name" => "f_link_text_3",
              "description" => esc_html__("Link text.", 'bookstore'),
              "dependency" => array('element' => 'f_style', 'value' => 'style3')
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("URL (Link) for Feature item 3", 'bookstore'),
              "param_name" => "f_link_3",
              "dependency" => array('element' => 'f_style', 'value' => 'style3')
          ),
            array(
              "type" => 'iconpicker',
              "holder" => "div",
              "class" => "bks_feature_box_inputs",
              "heading" => esc_html__("Icon for Feature item 3", 'bookstore'),
              "param_name" => "f_icon_3",
              "description" => esc_html__("Choose Icon", 'bookstore')
          ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra class name', 'js_composer'),
                'param_name' => 'el_class',
                'description' => esc_html__('If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'js_composer')
          ),
        )
    ) );

    /*
     *  VC Woocommerce products carousel
    */
    vc_map( array(
        "name" => esc_html__("Woo Carousel", 'bookstore'),
        "description" => esc_html__("Woo products carousel.", 'bookstore'),
        "base" => "bks_woo_carousel",
        "class" => "bks_woo_carousel",
        "controls" => "full",
        "icon" => "vc_navbar-brand", // or css class name which you can reffer in your css file later. Example: "vc_extend_my_class"
        "category" => esc_html__('Bookstore', 'bookstore'),
        "params" => array(
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_woo_carousel_inputs",
              "heading" => esc_html__("Number of products", 'bookstore'),
              "param_name" => "products_count",
              "description" => esc_html__("Number of products to show.", 'bookstore')
          ),
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_woo_carousel_inputs",
              "heading" => esc_html__("Product filter", 'bookstore'),
              "param_name" => "pr_filter",
              "value" => array('Select' => '', 'Recent Products' =>'recent', 'Featured' => 'featured', 'Top selling' => 'top_selling', 'Category' => 'category', 'Single Product Ids' => 'single_products'),
              "description" => esc_html__("Choose product filter type.", 'bookstore')
          ),
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_woo_carousel_inputs",
              "heading" => esc_html__("Order by", 'bookstore'),
              "param_name" => "pr_order_by",
               "value" => array('Select' => '', 'Date' => 'date', 'ID' => 'ID', 'Author' => 'author', 'Title' => 'title', 'Modified' => 'modified', 'Random', 'rand'),
              "description" => esc_html__("Select how to sort retrieved products.", 'bookstore')
          ),
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_woo_carousel_inputs",
              "heading" => esc_html__("Sort order", 'bookstore'),
              "param_name" => "pr_sort_order",
              "value" => array('Select' => '', 'Descending' => 'Desc', 'Ascending' => 'ASC'),
              "description" => esc_html__("Designates the ascending or descending order.", 'bookstore')
          ),
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_woo_carousel_inputs",
              "heading" => esc_html__("Choose category", 'bookstore'),
              "param_name" => "category_id",
              "value" => bookstore_get_terms_list('product_cat'),
              "dependency" => array('element' => 'pr_filter', 'value' => 'category')
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_woo_carousel_inputs",
              "heading" => esc_html__("Enter product ids", 'bookstore'),
              "param_name" => "product_ids",
              "description" => esc_html__("Input products ids by comma separated. Ex: 12,15,24", 'bookstore'),
              "dependency" => array('element' => 'pr_filter', 'value' => 'single_products')
          ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra class name', 'js_composer'),
                'param_name' => 'el_class',
                'description' => esc_html__('If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'js_composer')
          ),
        )
    ) );
    
    /*
     *  VC Woocommerce products lists
    */
    vc_map( array(
        "name" => esc_html__("Woo products list", 'bookstore'),
        "description" => esc_html__("Woo products list.", 'bookstore'),
        "base" => "bks_woo_product_list",
        "class" => "bks_woo_product_list",
        "controls" => "full",
        "icon" => "vc_navbar-brand", // or css class name which you can reffer in your css file later. Example: "vc_extend_my_class"
        "category" => esc_html__('Bookstore', 'bookstore'),
        "params" => array(
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_woo_product_list_inputs",
              "heading" => esc_html__("Number of products", 'bookstore'),
              "param_name" => "products_count",
              "description" => esc_html__("Number of products to show.", 'bookstore')
          ),
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_woo_product_list_inputs",
              "heading" => esc_html__("Product filter", 'bookstore'),
              "param_name" => "pr_filter",
              "value" => array('Select' => '', 'Featured' => 'featured', 'Top selling' => 'top_selling', 'Category' => 'category', 'Single Product Ids' => 'single_products'),
              "description" => esc_html__("Choose product filter type.", 'bookstore')
          ),
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_woo_product_list_inputs",
              "heading" => esc_html__("Order by", 'bookstore'),
              "param_name" => "pr_order_by",
               "value" => array('Select' => '', 'Date' => 'date', 'ID' => 'ID', 'Author' => 'author', 'Title' => 'title', 'Modified' => 'modified', 'Random', 'rand'),
              "description" => esc_html__("Select how to sort retrieved products.", 'bookstore')
          ),
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_woo_product_list_inputs",
              "heading" => esc_html__("Sort order", 'bookstore'),
              "param_name" => "pr_sort_order",
              "value" => array('Select' => '', 'Descending' => 'Desc', 'Ascending' => 'ASC'),
              "description" => esc_html__("Designates the ascending or descending order.", 'bookstore')
          ),
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_woo_product_list_inputs",
              "heading" => esc_html__("Choose category", 'bookstore'),
              "param_name" => "category_id",
              "value" => bookstore_get_terms_list('product_cat'),
              "dependency" => array('element' => 'pr_filter', 'value' => 'category')
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_woo_product_list_inputs",
              "heading" => esc_html__("Enter product ids", 'bookstore'),
              "param_name" => "product_ids",
              "description" => esc_html__("Input products ids by comma separated. Ex: 12,15,24", 'bookstore'),
              "dependency" => array('element' => 'pr_filter', 'value' => 'single_products')
          ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra class name', 'js_composer'),
                'param_name' => 'el_class',
                'description' => esc_html__('If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'js_composer')
          ),
        )
    ) );

    /*
     *  VC Testimonials extension
    */
    vc_map( array(
        "name" => esc_html__("Testimonials", 'bookstore'),
        "description" => esc_html__("Bookstore Testimonials.", 'bookstore'),
        "base" => "bks_testimonial",
        "class" => "bks_testimonial",
        "controls" => "full",
        "icon" => "vc_navbar-brand", // or css class name which you can reffer in your css file later. Example: "vc_extend_my_class"
        "category" => esc_html__('Bookstore', 'bookstore'),
        "params" => array(
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_testimonial_inputs",
              "heading" => esc_html__("Number of testimonials", 'bookstore'),
              "param_name" => "tsm_count",
              "description" => esc_html__("Number of testimonials to show.", 'bookstore')
          ),
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_testimonial_inputs",
              "heading" => esc_html__("Order by", 'bookstore'),
              "param_name" => "tsm_order_by",
               "value" => array('Select' => '', 'Date' => 'date', 'ID' => 'ID', 'Author' => 'author', 'Title' => 'title', 'Modified' => 'modified', 'Random', 'rand'),
              "description" => esc_html__("Select how to sort retrieved testimonials.", 'bookstore')
          ),
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_testimonial_inputs",
              "heading" => esc_html__("Sort order", 'bookstore'),
              "param_name" => "tsm_sort_order",
              "value" => array('Select' => '', 'Descending' => 'Desc', 'Ascending' => 'ASC'),
              "description" => esc_html__("Designates the ascending or descending order.", 'bookstore')
          ),
            array(
              "type" => "colorpicker",
              "holder" => "div",
              "class" => "bks_testimonial_inputs",
              "heading" => esc_html__("Font color", 'bookstore'),
              "param_name" => "font_color",
              "value" => '', 
              "description" => esc_html__("Choose Font color", 'bookstore'),
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_testimonial_inputs",
              "heading" => esc_html__("Font size for Testimonials", 'bookstore'),
              "param_name" => "font_size_tsm",
              "description" => esc_html__("Font size for Testimonials text.", 'bookstore')
          ),
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_testimonial_inputs",
              "heading" => esc_html__("Font style", 'bookstore'),
              "param_name" => "font_style",
              "value" => array('Select' => '', 'Normal' => 'normal', 'Italic' => 'italic'),
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_testimonial_inputs",
              "heading" => esc_html__("Font size for author names", 'bookstore'),
              "param_name" => "font_size_author_names",
              "description" => esc_html__("Font size for author names text.", 'bookstore')
          ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra class name', 'js_composer'),
                'param_name' => 'el_class',
                'description' => esc_html__('If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'js_composer')
          ),
        )
    ) );
    
    /*
     *  VC WordPress Post Slider
    */
    vc_map( array(
        "name" => esc_html__("WP Post Slider", 'bookstore'),
        "description" => esc_html__("BKS Post Slider.", 'bookstore'),
        "base" => "bks_post_slider",
        "class" => "bks_post_slider",
        "controls" => "full",
        "icon" => "vc_navbar-brand", // or css class name which you can reffer in your css file later. Example: "vc_extend_my_class"
        "category" => esc_html__('Bookstore', 'bookstore'),
        "params" => array(
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_post_slider_inputs",
              "heading" => esc_html__("Number of posts", 'bookstore'),
              "param_name" => "posts_count",
              "description" => esc_html__("Number of posts to show.", 'bookstore')
          ),
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_post_slider_inputs",
              "heading" => esc_html__("Post filter", 'bookstore'),
              "param_name" => "post_filter",
              "value" => array('Select' => '', 'Recent Posts' =>'recent', 'Category' => 'category'),
              "description" => esc_html__("Choose posts filter type.", 'bookstore')
          ),
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_post_slider_inputs",
              "heading" => esc_html__("Order by", 'bookstore'),
              "param_name" => "post_order_by",
               "value" => array('Select' => '', 'Date' => 'date', 'ID' => 'ID', 'Author' => 'author', 'Title' => 'title', 'Modified' => 'modified', 'Random', 'rand'),
              "description" => esc_html__("Select how to sort retrieved posts.", 'bookstore')
          ),
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_post_slider_inputs",
              "heading" => esc_html__("Sort order", 'bookstore'),
              "param_name" => "post_sort_order",
              "value" => array('Select' => '', 'Descending' => 'Desc', 'Ascending' => 'ASC'),
              "description" => esc_html__("Designates the ascending or descending order.", 'bookstore')
          ),
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_post_slider_inputs",
              "heading" => esc_html__("Choose category", 'bookstore'),
              "param_name" => "category_id",
              "value" => bookstore_get_terms_list('category'),
              "dependency" => array('element' => 'post_filter', 'value' => 'category')
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_post_slider_inputs",
              "heading" => esc_html__("Link to blog", 'bookstore'),
              "param_name" => "blog_link",
              "description" => esc_html__("Enter blog page url.", 'bookstore')
          ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra class name', 'js_composer'),
                'param_name' => 'el_class',
                'description' => esc_html__('If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'js_composer')
          ),
        )
    ) );
    
    vc_map( array(
        "name" => esc_html__("BKS List Icons", 'bookstore'),
        "description" => esc_html__("BKS List Icons with text.", 'bookstore'),
        "base" => "bks_icon_with_text",
        "class" => "bks_icon_with_text",
        "controls" => "full",
        "icon" => "vc_navbar-brand",
        "category" => esc_html__('Bookstore', 'bookstore'),
        "params" => array(
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_list_icons_inputs",
              "heading" => esc_html__("Title", 'bookstore'),
              "param_name" => "title_text",
              "value" => esc_html__("", 'bookstore'),
              "description" => esc_html__("Title of the icon element.", 'bookstore')
          ),
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_list_icons_inputs",
              "heading" => esc_html__("Title tag", 'bookstore'),
              "param_name" => "title_tag",
              "value" => array('h1' => 'h1', 'h2' => 'h2', 'h3' => 'h3', 'h4' => 'h4', 'h5' => 'h5','h6' => 'h6',),
              "description" => esc_html__("Select element tag.", 'bookstore')
          ),
            array(
              "type" => "textfield",
              "holder" => "div",
              "class" => "bks_list_icons_inputs",
              "heading" => esc_html__("Link", 'bookstore'),
              "param_name" => "title_link",
              "value" => esc_html__("", 'bookstore'),
              "description" => esc_html__("Link to title.", 'bookstore')
          ),
            array(
              "type" => 'iconpicker',
              "holder" => "div",
              "class" => "bks_list_icons_inputs",
              "heading" => esc_html__("Select Icon", 'bookstore'),
              "param_name" => "list_icon",
              "description" => esc_html__("Choose Icon", 'bookstore'),
              //"dependency" => array('element' => 'add_icon', 'value' => 'true')
          ),
            array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "bks_list_icons_inputs",
              "heading" => esc_html__("Icon size", 'bookstore'),
              "param_name" => "icon_size",
              "value" => array( 'Mini' => 'Mini',  'Small' => 'Small', 'Normal' => 'Normal', 'Large' => 'Large', 'Max' => 'Max'),
              "description" => esc_html__("Select icon size.", 'bookstore')
          ),
//            array(
//              "type" => "textfield",
//              "holder" => "div",
//              "class" => "bks_list_icons_inputs",
//              "heading" => esc_html__("Line height", 'bookstore'),
//              "param_name" => "line_height",
//              "description" => esc_html__("Enter line height.", 'bookstore')
//          ),
            array(
              "type" => "colorpicker",
              "holder" => "div",
              "class" => "bks_list_icons_inputs",
              "heading" => esc_html__("Heading color", 'bookstore'),
              "param_name" => "text_color",
              "description" => esc_html__("Select heading color", 'bookstore'),
          ),
            array(
              "type" => "colorpicker",
              "holder" => "div",
              "class" => "bks_list_icons_inputs",
              "heading" => esc_html__("Background color", 'bookstore'),
              "param_name" => "icon_bg_color",
              "description" => esc_html__("Select icon background color", 'bookstore'),
          ),
            array(
              "type" => "colorpicker",
              "holder" => "div",
              "class" => "bks_list_icons_inputs",
              "heading" => esc_html__("Icon color", 'bookstore'),
              "param_name" => "icon_color",
              "description" => esc_html__("Select icon color", 'bookstore'),
          ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra class name', 'js_composer'),
                'param_name' => 'el_class',
                'description' => esc_html__('If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'js_composer')
          ),
        )
    ) );

}