<?php
/*
Template name: With Right Sidebar
*/

/* 
 * @package   bookstore
 * @author    AcmeeDesign
 * @link      http://acmeedesign.com
 * @since     1.0
 */

get_header(); 

echo wp_kses_post(bookstore_breadcrumb('page-header'));

?>

<div class="container">
    <div class="padding-40-v">
        <div id="main-content">

            <div id="content" role="main" class="col-xs-12 col-sm-8 col-md-9 left">

                <?php while ( have_posts() ) : the_post(); ?>

                        <?php the_content(); ?>

                <?php endwhile; ?>

            </div><!-- #content -->

            <div id="page-sidebar" class="sidebar col-xs-12 col-sm-4 col-md-3 right">
                <?php 
                    if(is_active_sidebar('pages-sidebar')) { 
                        dynamic_sidebar('pages-sidebar');
                    } 
                    else {
                        esc_html_e('No widgets added.', 'bookstore');
                    }
                ?>
            </div><!-- #sidebar -->

        </div><!-- .main-content -->
    </div>
</div><!-- .container -->

<?php 
//get footer file
get_footer();