<?php
/* 
 * @package   bookstore
 * @author    AcmeeDesign
 * @link      http://acmeedesign.com
 * @since     1.0
 */

 get_header(); 
 
 $bookstore_options = (function_exists('bookstore_options')) ? bookstore_options() : "";

if(isset($bookstore_options['blog_sidebar_position']) && $bookstore_options['blog_sidebar_position'] == "left") {
    $content_class = "right";
    $sidebar_class = "left";
}
else {
    $content_class = "left";
    $sidebar_class = "right";
}

echo wp_kses_post(bookstore_breadcrumb('page-header'));

 ?>

<div class="container padding-40-v">
    <div id="main-content">
        
        <div id="content" role="main" class="col-sm-8 col-md-9 <?php echo esc_html($content_class); ?>">
            <?php
            get_template_part( 'content', 'search-form' );
            ?>
            
            <?php if ( have_posts() ) : ?>
                <header class="search-title">
                        <h1><?php printf( esc_html__ ( 'Search Results for: %s', 'bookstore' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
                </header><!-- .page-header -->

                    <?php while ( have_posts() ) : the_post(); ?>

                            <?php
                                    /* Post-Format-specific template.
                                     * To override this theme with a child theme include file with filename
                                     *  content-xxx.php  xxx - will be your post format.
                                     */
                                    get_template_part( 'content', get_post_format() );
                            ?>

                    <?php endwhile; ?>

            <?php else : ?>

                    <?php get_template_part( 'no-posts', 'index' ); ?>

            <?php endif; ?>

            <?php bookstore_posts_nav(); ?>
            
        </div><!-- #content -->

        <div id="page-sidebar" class="sidebar col-xs-12 col-sm-4 col-md-3 <?php echo esc_html($sidebar_class); ?>">
            <?php get_sidebar(); ?>
        </div><!-- #sidebar -->

    </div><!-- .main-content -->
</div><!-- .container -->
<?php 
//get footer file
get_footer();