<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.0.0
 */

 if ( ! defined( 'ABSPATH' ) ) {
 	exit; // Exit if accessed directly
 }

 global $product, $woocommerce_loop;

 // Store loop count we're currently on
 if ( empty( $woocommerce_loop['loop'] ) ) {
 	$woocommerce_loop['loop'] = 0;
 }

 // Store column count for displaying the grid
 if ( empty( $woocommerce_loop['columns'] ) ) {
 	$woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 4 );
 }

 // Ensure visibility
 if ( ! $product || ! $product->is_visible() ) {
 	return;
 }

 // Increase loop count
 $woocommerce_loop['loop']++;

 // Extra post classes
 $classes = array();
 $classes[] = 'item';
 $classes[] = 'col-xs-12 col-sm-4';

 $post_id = $post->ID;
 $stock_status = get_post_meta($post_id, '_stock_status',true) == 'outofstock';
 ?>
 <div <?php  post_class( $classes ); ?>>
     <div class="product-wrap">
             <?php wc_get_template( 'loop/sale-flash.php' ); ?>
             <div class="product-image">
               <?php if ( has_post_thumbnail() ){ ?>
                <div class="catalog-image">
                    <a href="<?php the_permalink(); ?>">
                         <?php echo get_the_post_thumbnail( $post->ID, 'bookstore_product_thumb') ?>
                         <div class="button yith-wcqv-button" data-product_id="<?php echo esc_html($post->ID); ?>">
                              <i class="fa fa-search"></i>
                         </div>
                    </a>
                </div>
               <?php }

                     else {
                         echo bookstore_get_ph_image('532x452.png');
                     } ?>

                 <div class="product-buttons">
                       <?php
                         //woocommerce_get_template( 'loop/add-to-cart.php' );
                       echo apply_filters( 'woocommerce_loop_add_to_cart_link',
                     sprintf( '<div class="add-to-cart-btn"><a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="%s">%s</a></div>',
                                     esc_url( $product->add_to_cart_url() ),
                                     esc_attr( $product->get_id() ),
                                     esc_attr( $product->get_sku() ),
                                     esc_attr( isset( $quantity ) ? $quantity : 1 ),
                                     //$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
 																		esc_attr( isset( $class ) ? $class : 'button' ),
                                     esc_html( $product->add_to_cart_text() )
                             ),
                     $product );
                       if(shortcode_exists( 'yith_compare_button' ) ) {
                       ?>
                        <div class="yith_compare_btn">
                             <?php echo do_shortcode('[yith_compare_button]'); ?>
                        </div>
                         <?php
                       }
                       if(shortcode_exists( 'yith_wcwl_add_to_wishlist' ) ) {
                           echo do_shortcode('[yith_wcwl_add_to_wishlist]');
                       }
                         ?>

                  <?php if($stock_status == "1") { ?><div class="out-of-stock-label"><?php esc_html_e ( 'Out of stock', 'woocommerce' ); ?></div><?php }?>

                    </div>

                </div><!-- end product-image -->
            <div class="product-content">

                <h4 class="product_title"><a class="bks_product_title_link" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                <?php do_action( 'woocommerce_after_shop_loop_item_title' ); ?>
                <div class="product-desc">
                    <?php echo apply_filters( 'woocommerce_short_description', $post->post_excerpt ) ?>
                </div>

                <div class="product-buttons">
                       <?php

                       echo apply_filters( 'woocommerce_loop_add_to_cart_link',
                     sprintf( '<div class="add-to-cart-btn"><a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="%s">%s</a></div>',
                                     esc_url( $product->add_to_cart_url() ),
                                     esc_attr( $product->get_id() ),
                                     esc_attr( $product->get_sku() ),
                                     esc_attr( isset( $quantity ) ? $quantity : 1 ),
                                     //$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
 																		esc_attr( isset( $class ) ? $class : 'button' ),
                                     esc_html( $product->add_to_cart_text() )
                             ),
                     $product );
                       if(shortcode_exists( 'yith_compare_button' ) ) {
                       ?>
                        <div class="yith_compare_btn">
                             <?php echo do_shortcode('[yith_compare_button]'); ?>
                        </div>
                         <?php
                       }
                       if(shortcode_exists( 'yith_wcwl_add_to_wishlist' ) ) {
                               echo do_shortcode('[yith_wcwl_add_to_wishlist]');
                       }
                         ?>

                  <?php if($stock_status == "1") { ?><div class="out-of-stock-label"><?php esc_html_e ( 'Out of stock', 'woocommerce' ); ?></div><?php }?>

                    </div>

            </div><!-- end product-content -->


     </div>
 </div>
