<?php
/* 
 * @package   bookstore
 * @author    AcmeeDesign
 * @link      http://acmeedesign.com
 * @since     1.0
 */

function acm_get_image_url($id, $size = "full") {
    global $wpdb;
    if(is_numeric($id)) {
        $imageAttachment = wp_get_attachment_image_src( $id, $size );
        return $imageAttachment[0];
    }
}

function acm_rand_key($length)
{
        $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";	

        $size = strlen( $chars );
        $str = "";
        for( $i = 0; $i < $length; $i++ ) {
                $str .= $chars[ rand( 0, $size - 1 ) ];
        }

        return $str;
}

function acm_clean_font_size($fontsize) {
    $fontsize = trim($fontsize);
    if(!is_numeric($fontsize)) {
        return str_replace('px', '', $fontsize);
    }
    else {
        return $fontsize;
    }
}

function acm_clean_color_code($code) {
    $code = trim($code);
    if(!is_numeric($code)) {
        return str_replace('#', '', $code);
    }
    else {
        return $code;
    }
}

function acm_get_ph_image($image) {
    if(!empty($image)) {
        $output = "<img src='" . get_stylesheet_directory_uri() . "/assets/images/placeholders/" . $image . "' alt='placeholder' />" ;
        return wp_kses_post($output);
    }
}

/*Custom excerpt length function
 * @return excerpt with formatting
 */
function acm_custom_excerpt($excerpt_length = 55, $id = false, $echo = true) {
	  
    $text = '';
    
    if($id) {
          $the_post = & get_post( $my_id = $id );
          $text = ($the_post->post_excerpt) ? $the_post->post_excerpt : $the_post->post_content;
    } else {
          global $post;
          $text = ($post->post_excerpt) ? $post->post_excerpt : get_the_content('');
    }

          $text = strip_shortcodes( $text );
          $text = apply_filters('the_content', $text);
          $text = str_replace(']]>', ']]&gt;', $text);
          $text = strip_tags($text);

          $excerpt_more = ' ' . '...';
          $words = preg_split("/[\n\r\t ]+/", $text, $excerpt_length + 1, PREG_SPLIT_NO_EMPTY);
          if ( count($words) > $excerpt_length ) {
                  array_pop($words);
                  $text = implode(' ', $words);
                  $text = $text . $excerpt_more;
          } else {
                  $text = implode(' ', $words);
          }
  if($echo)
      echo apply_filters('the_content', $text);
  else
  return $text;
}