<?php
/* 
 * @package   bookstore
 * @author    AcmeeDesign
 * @link      http://acmeedesign.com
 * @since     1.0
 */

add_action( 'tgmpa_register', 'bookstore_register_required_plugins' );
/**
 * Register the required plugins for this theme.
 *
 * In this example, we register five plugins:
 * - one included with the TGMPA library
 * - two from an external source, one from an arbitrary source, one from a GitHub repository
 * - two from the .org repo, where one demonstrates the use of the `is_callable` argument
 *
 * The variable passed to tgmpa_register_plugins() should be an array of plugin
 * arrays.
 *
 * This function is hooked into tgmpa_init, which is fired within the
 * TGM_Plugin_Activation class constructor.
 */
function bookstore_register_required_plugins() {
    
    $plugins_dir = get_template_directory() . '/includes/plugins';
    
    $plugins = array(

            // This is an example of how to include a plugin bundled with a theme.
            array(
                    'name'               => esc_html__('WooCommerce', 'bookstore'), // The plugin name.
                    'slug'               => 'woocommerce', // The plugin slug (typically the folder name).
                    'required'           => true, // If false, the plugin is only 'recommended' instead of required.
            ),
            array(
                    'name'               => esc_html__('Acmee Theme Functions', 'bookstore'), // The plugin name.
                    'slug'               => 'acmee-theme-functions', // The plugin slug (typically the folder name).
                    'source'             => $plugins_dir . '/acmee-theme-functions.zip', // The plugin source.
                    'required'           => true, // If false, the plugin is only 'recommended' instead of required.
                    'version'            => '1.0', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
                    'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
                    'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            ),
            array(
                    'name'               => esc_html__('Redux Framework', 'bookstore'), // The plugin name.
                    'slug'               => 'redux-framework', // The plugin slug (typically the folder name).
                    'required'           => true, // If false, the plugin is only 'recommended' instead of required.
            ),
            array(
                    'name'               => esc_html__('Redux Vendor Support', 'bookstore'), // The plugin name.
                    'slug'               => 'redux-vendor-support-master', // The plugin slug (typically the folder name).
                    'source'             => $plugins_dir . '/redux-vendor-support-master.zip', // The plugin source.
                    'required'           => true, // If false, the plugin is only 'recommended' instead of required.
                    'version'            => '1.0.1', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
                    'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
                    'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            ),
            array(
                'name'               => esc_html__('Visual Composer', 'bookstore'), // The plugin name.
                'slug'               => 'js_composer', // The plugin slug (typically the folder name).
                'source'             => $plugins_dir . '/js_composer.zip', // The plugin source.
                'required'           => true, // If false, the plugin is only 'recommended' instead of required.
                'version'            => '4.9.2', // E.g. 1.0.0. If set, the active plugin must be this version or higher.
                'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
                'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            ),
            array(
                'name'               => esc_html__('Slider Revolution', 'bookstore'), // The plugin name.
                'slug'               => 'revslider', // The plugin slug (typically the folder name).
                'source'             => $plugins_dir . '/revslider.zip', // The plugin source.
                'required'           => true, // If false, the plugin is only 'recommended' instead of required.
                'version'            => '5.1.6', // E.g. 1.0.0. If set, the active plugin must be this version or higher.
                'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
                'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            ),
            array(
                'name'               => esc_html__('VC Mega Menu', 'bookstore'), // The plugin name.
                'slug'               => 'vc-mega-menu', // The plugin slug (typically the folder name).
                'source'             => $plugins_dir . '/vc-mega-menu.zip', // The plugin source.
                'required'           => true, // If false, the plugin is only 'recommended' instead of required.
                'version'            => '1.3', // E.g. 1.0.0. If set, the active plugin must be this version or higher.
                'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
                'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            ),
            array(
                'name'               => esc_html__('YITH WooCommerce Wishlist', 'bookstore'), // The plugin name.
                'slug'               => 'yith-woocommerce-wishlist', // The plugin slug (typically the folder name).
                'required'           => false, // If false, the plugin is only 'recommended' instead of required.
            )
           ,array(
                'name'               => esc_html__('YITH WooCommerce Compare', 'bookstore'), // The plugin name.
                'slug'               => 'yith-woocommerce-compare', // The plugin slug (typically the folder name).
                'required'           => true, // If false, the plugin is only 'recommended' instead of required.
                'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
                'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            ),
            array(
                'name'               => esc_html__('YITH WooCommerce Quick View', 'bookstore'), // The plugin name.
                'slug'               => 'yith-woocommerce-quick-view', // The plugin slug (typically the folder name).
                'required'           => true, // If false, the plugin is only 'recommended' instead of required.
                'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
                'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            ),
            array(
                'name'               => esc_html__('YITH WooCommerce Ajax Search', 'bookstore'), // The plugin name.
                'slug'               => 'yith-woocommerce-ajax-search', // The plugin slug (typically the folder name).
                'required'           => false, // If false, the plugin is only 'recommended' instead of required.
            ),
            array(
                'name'               => esc_html__('Responsive Video Shortcodes', 'bookstore'), // The plugin name.
                'slug'               => 'responsive-video-shortcodes', // The plugin slug (typically the folder name).
                'required'           => false, // If false, the plugin is only 'recommended' instead of required.
            ),
            array(
                'name'               => esc_html__('Regenerate Thumbnails', 'bookstore'), // The plugin name.
                'slug'               => 'regenerate-thumbnails', // The plugin slug (typically the folder name).
                'required'           => false, // If false, the plugin is only 'recommended' instead of required.
            ),
            array(
                'name'               => esc_html__('WooCommerce Currency Switcher', 'bookstore'), // The plugin name.
                'slug'               => 'woocommerce-currency-switcher', // The plugin slug (typically the folder name).
                'required'           => false, // If false, the plugin is only 'recommended' instead of required.
            ),
            array(
                'name'               => esc_html__('Contact Form 7', 'bookstore'), // The plugin name.
                'slug'               => 'contact-form-7', // The plugin slug (typically the folder name).
                'required'           => false, // If false, the plugin is only 'recommended' instead of required.
            ),
            array(
                'name'               => esc_html__('SoundCloud Shortcode', 'bookstore'), // The plugin name.
                'slug'               => 'soundcloud-shortcode', // The plugin slug (typically the folder name).
                'required'           => false, // If false, the plugin is only 'recommended' instead of required.
            )


    );

    /*
     * Array of configuration settings. Amend each line as needed.
     *
     * TGMPA will start providing localized text strings soon. If you already have translations of our standard
     * strings available, please help us make TGMPA even better by giving us access to these translations or by
     * sending in a pull-request with .po file(s) with the translations.
     *
     * Only uncomment the strings in the config array if you want to customize the strings.
     */
    $config = array(
            'id'           => 'bookstore',                 // Unique ID for hashing notices for multiple instances of TGMPA.
            'default_path' => '',                      // Default absolute path to bundled plugins.
            'menu'         => 'tgmpa-install-plugins', // Menu slug.
            'parent_slug'  => 'themes.php',            // Parent menu slug.
            'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
            'has_notices'  => true,                    // Show admin notices or not.
            'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
            'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
            'is_automatic' => false,                   // Automatically activate plugins after installation or not.
            'message'      => '',                      // Message to output right before the plugins table.

            /*
            'strings'      => array(
                    'page_title'                      => esc_html__( 'Install Required Plugins', 'theme-slug' ),
                    'menu_title'                      => esc_html__( 'Install Plugins', 'theme-slug' ),
                    'installing'                      => esc_html__( 'Installing Plugin: %s', 'theme-slug' ), // %s = plugin name.
                    'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'theme-slug' ),
                    'notice_can_install_required'     => _n_noop(
                            'This theme requires the following plugin: %1$s.',
                            'This theme requires the following plugins: %1$s.',
                            'theme-slug'
                    ), // %1$s = plugin name(s).
                    'notice_can_install_recommended'  => _n_noop(
                            'This theme recommends the following plugin: %1$s.',
                            'This theme recommends the following plugins: %1$s.',
                            'theme-slug'
                    ), // %1$s = plugin name(s).
                    'notice_cannot_install'           => _n_noop(
                            'Sorry, but you do not have the correct permissions to install the %1$s plugin.',
                            'Sorry, but you do not have the correct permissions to install the %1$s plugins.',
                            'theme-slug'
                    ), // %1$s = plugin name(s).
                    'notice_ask_to_update'            => _n_noop(
                            'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.',
                            'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.',
                            'theme-slug'
                    ), // %1$s = plugin name(s).
                    'notice_ask_to_update_maybe'      => _n_noop(
                            'There is an update available for: %1$s.',
                            'There are updates available for the following plugins: %1$s.',
                            'theme-slug'
                    ), // %1$s = plugin name(s).
                    'notice_cannot_update'            => _n_noop(
                            'Sorry, but you do not have the correct permissions to update the %1$s plugin.',
                            'Sorry, but you do not have the correct permissions to update the %1$s plugins.',
                            'theme-slug'
                    ), // %1$s = plugin name(s).
                    'notice_can_activate_required'    => _n_noop(
                            'The following required plugin is currently inactive: %1$s.',
                            'The following required plugins are currently inactive: %1$s.',
                            'theme-slug'
                    ), // %1$s = plugin name(s).
                    'notice_can_activate_recommended' => _n_noop(
                            'The following recommended plugin is currently inactive: %1$s.',
                            'The following recommended plugins are currently inactive: %1$s.',
                            'theme-slug'
                    ), // %1$s = plugin name(s).
                    'notice_cannot_activate'          => _n_noop(
                            'Sorry, but you do not have the correct permissions to activate the %1$s plugin.',
                            'Sorry, but you do not have the correct permissions to activate the %1$s plugins.',
                            'theme-slug'
                    ), // %1$s = plugin name(s).
                    'install_link'                    => _n_noop(
                            'Begin installing plugin',
                            'Begin installing plugins',
                            'theme-slug'
                    ),
                    'update_link' 					  => _n_noop(
                            'Begin updating plugin',
                            'Begin updating plugins',
                            'theme-slug'
                    ),
                    'activate_link'                   => _n_noop(
                            'Begin activating plugin',
                            'Begin activating plugins',
                            'theme-slug'
                    ),
                    'return'                          => esc_html__( 'Return to Required Plugins Installer', 'theme-slug' ),
                    'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'theme-slug' ),
                    'activated_successfully'          => esc_html__( 'The following plugin was activated successfully:', 'theme-slug' ),
                    'plugin_already_active'           => esc_html__( 'No action taken. Plugin %1$s was already active.', 'theme-slug' ),  // %1$s = plugin name(s).
                    'plugin_needs_higher_version'     => esc_html__( 'Plugin not activated. A higher version of %s is needed for this theme. Please update the plugin.', 'theme-slug' ),  // %1$s = plugin name(s).
                    'complete'                        => esc_html__( 'All plugins installed and activated successfully. %1$s', 'theme-slug' ), // %s = dashboard link.
                    'contact_admin'                   => esc_html__( 'Please contact the administrator of this site for help.', 'tgmpa' ),

                    'nag_type'                        => 'updated', // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
            ),
            */
    );

    tgmpa( $plugins, $config );
}