<?php
/*
 * @package   bookstore
 * @author    AcmeeDesign
 * @link      http://acmeedesign.com
 * @since     1.0
 */

function bookstore_customCSS() {
    global $bookstore_options;

    $css_styles = "";
    //Font styles
    //Body
    $css_styles .= 'body { ';

    if(isset($bookstore_options['body_font_style']['color'])) {
        $css_styles .= 'color: ' . $bookstore_options['body_font_style']['color'] . ';';
    }
    if(isset($bookstore_options['body_font_style']['font-family'])) {
        $css_styles .= 'font-family: ' . $bookstore_options['body_font_style']['font-family'] . ';';
    }
    if(isset($bookstore_options['body_font_style']['font-weight'] )) {
        $css_styles .= 'font-weight: '  . $bookstore_options['body_font_style']['font-weight'] . ';';
    }
    if(isset($bookstore_options['body_font_style']['line-height'])) {
        $css_styles .= 'line-height: '  . bookstore_clean_font_size($bookstore_options['body_font_style']['line-height']) . 'px;';
    }

    $css_styles .= ' } ';

    //Read more
    if(isset($bookstore_options['anchor_text_color'])) {
        $css_styles .= '.read-more { ';
        $css_styles .= 'color:' .$bookstore_options['anchor_text_color'] . ' !important;' ;
        $css_styles .= ' } ';
    }
     if(isset($bookstore_options['anchor_text_hover_color'])) {
        $css_styles .= '.read-more:hover { ';
        $css_styles .= 'color:' .$bookstore_options['anchor_text_hover_color'] . ' !important;' ;
        $css_styles .= ' } ';
        $css_styles .= '.btn-link:after { ';
        $css_styles .= 'background:' .$bookstore_options['anchor_text_hover_color'] . ' !important;' ;
        $css_styles .= ' } ';
     }

    //Headings
    $css_styles .= 'h1,h2,h3,h4,h5,h6 {';

    if(isset($bookstore_options['heading_font_styles']['color'])) {
        $css_styles .= 'color:' . $bookstore_options['heading_font_styles']['color'] . ';' ;
    }
    if(isset($bookstore_options['heading_font_styles']['font-weight'])) {
       // $css_styles .= 'font-weight:' .$bookstore_options['heading_font_styles']['font-weight'] . ';' ;

    }
    if(isset($bookstore_options['heading_font_styles']['font-family'] )) {
        $css_styles .= 'font-family:' .$bookstore_options['heading_font_styles']['font-family'] . ';' ;
    }
     $css_styles .= ' } ';

     //Topbar
     $css_styles .= '.topbar { ';
     if(isset($bookstore_options['topbar_bg_color'])) {
         $css_styles .= 'background-color:' .$bookstore_options['topbar_bg_color'] . ';' ;
     }
     if(isset($bookstore_options['topbar_text_color'])) {
         $css_styles .= 'color:' .$bookstore_options['topbar_text_color'] . ';' ;
     }
     $css_styles .= ' } ';
     if(isset($bookstore_options['topbar_link_color']['regular'])) {
         $css_styles .= '.topbar .nav > li.current_page_item a, .topbar .nav > li.current-menu-item a { ';
         $css_styles .= 'color:' .$bookstore_options['topbar_link_color']['active'] . ';' ;
         $css_styles .= ' } ';
         $css_styles .= '.topbar .nav > li a:hover { ';
         $css_styles .= 'color:' .$bookstore_options['topbar_link_color']['hover'] . ';' ;
         $css_styles .= ' } ';
         $css_styles .= '.topbar .nav > li a { ';
         $css_styles .= 'color:' .$bookstore_options['topbar_link_color']['regular'] . ';' ;
              if(isset($bookstore_options['topbar_menu_border_color'])) {
                    $css_styles .= 'border-color:' .$bookstore_options['topbar_menu_border_color'] . ';' ;
               }
         $css_styles .= ' } ';
     }

     if(isset($bookstore_options['topbar_icons_color'])) {
         $css_styles .= '.topbar i { ';
         $css_styles .= 'color:' .$bookstore_options['topbar_icons_color'] . ';' ;
         $css_styles .= ' } ';
     }

     if(isset($bookstore_options['header_bg_color'])) {
         $css_styles .= '.header { ';
         $css_styles .= 'background-color:' .$bookstore_options['header_bg_color'] . ';' ;
         $css_styles .= ' } ';
     }

     //Currency switcher
     if(isset($bookstore_options['currency_bg_color'])) {
         $css_styles .= '.bks-cart-widget .currency-switcher .dd-select { ';
         $css_styles .= 'background:' .$bookstore_options['currency_bg_color'] . ' !important;' ;
         $css_styles .= ' } ';
     }
     if(isset($bookstore_options['currency_border_color'])) {
         $css_styles .= '.bks-cart-widget .currency-switcher, .bks-cart-widget .minicart-button { ';
         $css_styles .= 'border-color:' .$bookstore_options['currency_border_color'] . ' ;' ;
         $css_styles .= ' } ';
     }
     if(isset($bookstore_options['currency_text_color']['regular'])) {
         $css_styles .= '.bks-cart-widget .currency-switcher a, .bks-cart-widget .minicart-button .cart-item-info a { ';
         $css_styles .= 'color:' .$bookstore_options['currency_text_color']['regular'] . ';' ;
         $css_styles .= ' } ';
         $css_styles .= '.bks-cart-widget .dd-pointer-down {';
         $css_styles .= 'border-top-color: '.$bookstore_options['currency_text_color']['regular'] . ';' ;
         $css_styles .= ' } ';
     }
     if(isset($bookstore_options['currency_text_color']['hover'])) {
         $css_styles .= '.bks-cart-widget .currency-switcher a.dd-selected:hover { ';
         $css_styles .= 'color:' .$bookstore_options['currency_text_color']['hover'] . ';' ;
         $css_styles .= ' } ';
     }
     if(isset($bookstore_options['currency_drop_bg_color'])) {
         $css_styles .= '.bks-cart-widget .currency-switcher .dd-options { ';
         $css_styles .= 'background:' .$bookstore_options['currency_drop_bg_color'] . ';' ;
         $css_styles .= ' } ';
     }
     if(isset($bookstore_options['currency_drop_hover_bg_color'])) {
         $css_styles .= '.bks-cart-widget .currency-switcher ul.dd-options li:hover { ';
         $css_styles .= 'background:' .$bookstore_options['currency_drop_hover_bg_color'] . ';' ;
         $css_styles .= ' } ';
     }
     if(isset($bookstore_options['currency_drop_text_color']['regular'])) {
         $css_styles .= '.bks-cart-widget .currency-switcher ul.dd-options a { ';
         $css_styles .= 'color:' .$bookstore_options['currency_drop_text_color']['regular'] . ';' ;
         $css_styles .= ' } ';
     }
     if(isset($bookstore_options['currency_drop_text_color']['hover'])) {
         $css_styles .= '.bks-cart-widget .currency-switcher ul.dd-options li:hover a { ';
         $css_styles .= 'color:' .$bookstore_options['currency_drop_text_color']['hover'] . ';' ;
         $css_styles .= ' } ';
     }


     //Menu
     if(is_user_logged_in()) {
       $css_styles .= '.main-menu.affix{top:32px!important}';
     }
     $css_styles .= '.main-menu, .main-menu .vc-mm-menu-h > ul.vc-nav-on-desktop > li > a { ';
     if(isset($bookstore_options['top_menu_bg_color'])) {
         $css_styles .= 'background: ' . $bookstore_options['top_menu_bg_color'] . ';';
     }
     else {
         $css_styles .= 'background: #27ae61;';
     }
     if(isset($bookstore_options['menu_link_colors']['regular'])) {
         $css_styles .= 'color:' .$bookstore_options['menu_link_colors']['regular'] . ';' ;
     }
     if(isset($bookstore_options['main_menu_fonts']['font-weight'])) {
       //  $css_styles .= ' font-weight: ' . $bookstore_options['main_menu_fonts']['font-weight']. ';' ;
     }
     if(isset($bookstore_options['main_menu_fonts']['font-family'])) {
         $css_styles .= 'font-family: ' . $bookstore_options['main_menu_fonts']['font-family'] . ';' ;
     }
     if(isset($bookstore_options['main_menu_fonts']['font-size'])) {
         $css_styles .= 'font-size:' . $bookstore_options['main_menu_fonts']['font-size'] . ';' ;
     }
     $css_styles .= ' } ';

     $css_styles .= '.main-menu .vc-mm-menu-h > ul.vc-nav-on-desktop > li > a:hover, .main-menu .vc-mm-menu-h > ul.vc-nav-on-desktop > li:hover > a {';
     if(isset($bookstore_options['menu_link_colors']['hover'])) {
         $css_styles .= 'color:' .$bookstore_options['menu_link_colors']['hover'] . ';' ;
     }
     else {
         $css_styles .= 'color:#fff';
     }
     $css_styles .= ' } ';

     $css_styles .= '.main-menu .vc-mm-menu-h > ul.vc-nav-on-desktop li.current-menu-item > a, .main-menu .vc-mm-menu-h > ul.vc-nav-on-desktop li.current-menu-ancestor > a, .main-menu .vc-mm-menu-h > ul.vc-nav-on-desktop li.current-menu-parent > a,
           .main-menu .vc-mm-menu-h > ul.vc-nav-on-desktop li.current-page-item > a { ';
     if(isset($bookstore_options['menu_link_colors']['active'])) {
         $css_styles .= 'color:' .$bookstore_options['menu_link_colors']['active'] . ';' ;
     }
     else {
         $css_styles .= 'color:#fff';
     }
     $css_styles .= ' } ';

     if(isset($bookstore_options['menu_hover_type']) && $bookstore_options['menu_hover_type'] == 2) {
        $css_styles .= '.main-menu .vc-mm-menu-h > ul.vc-nav-on-desktop > li:hover > a.nav-link:after,
             .main-menu .vc-mm-menu-h > ul.vc-nav-on-desktop > li.current-menu-item > a.nav-link:after,
             .main-menu .vc-mm-menu-h > ul.vc-nav-on-desktop > li.current-menu-ancestor > a.nav-link:after,
             .main-menu .vc-mm-menu-h > ul.vc-nav-on-desktop > li.ccurrent_page_item > a.nav-link:after { ';
        $css_styles .= 'position: absolute;
            content: "";
            background: #ffffff;
            left: 0px;
            bottom: 0;
            width: 100%;
            height: 3px;';
        if(isset($bookstore_options['top_menu_border_color'])) {
            $css_styles .= 'background: ' . $bookstore_options['top_menu_border_color'] . ';';
        }
        $css_styles .= ' } ';

    }
    else if (isset($bookstore_options['menu_hover_type']) && $bookstore_options['menu_hover_type'] == 1) {
        $css_styles .= '.main-menu .vc-nav-on-desktop > li:hover > a.nav-link,.main-menu .vc-nav-on-desktop > li.current-menu-ancestor > a.nav-link,
        .main-menu .vc-nav-on-desktop > li.current-menu-item > a.nav-link,
        .main-menu .vc-nav-on-desktop > li.current-page-item > a.nav-link { ';
        $css_styles .= 'background: ' . $bookstore_options['top_menu_hover_bg_color'] . ';';
        $css_styles .= ' } ';
        $css_styles .= '.main-menu .vc-nav-on-desktop > li.current-menu-item > a.nav-link,
                .main-menu vc-nav-on-desktop > li.current_page_item > a.nav-link { ';
        $css_styles .= 'background: ' . $bookstore_options['top_menu_active_bg_color'] . ';';
        $css_styles .= ' } ';
    }

    if(isset($bookstore_options['sub_menu_bg_color'])) {
        $css_styles .= '.main-menu .vc-mm-mega-cont, .main-menu .sub-menu, .main-menu .vc-mm-menu-h .vc-nav-on-desktop .vc-mm-mega-cont-inner {';
        $css_styles .= 'background-color: ' . $bookstore_options['sub_menu_bg_color'] . ' !important;';
        $css_styles .= ' } ';
    }
    if(isset($bookstore_options['sub_menu_color'])) {
        $css_styles .= '.main-menu .vc-mm-mega-cont li a, .sub-menu-inner li a.nav-link, .vc-mm-menu a, .vc-mm-menu li a {';
        $css_styles .= 'color: ' . $bookstore_options['sub_menu_color'] . ';';
        $css_styles .= ' } ';
    }
    if(isset($bookstore_options['sub_menu_hover_color'])) {
        $css_styles .= '.main-menu .vc-mm-mega-cont li a:hover, .main-menu ul.sub-menu-inner li a:hover, .main-menu .vc-mm-mega-cont li a:hover, .main-menu .vc-mm-mega-cont-inner li.current-menu-parent a {';
        $css_styles .= 'color: ' . $bookstore_options['sub_menu_hover_color'] . ' !important;';
        $css_styles .= ' } ';
    }
    if(isset($bookstore_options['sub_menu_border_color'])) {
        $css_styles .= '.main-menu .vc-mm-mega-cont ul li {';
        $css_styles .= 'border-color: ' . $bookstore_options['sub_menu_border_color'] . ' !important;';
        $css_styles .= ' } ';
    }


    $css_styles .= 'body.boxed-layout { ';
    if(isset($bookstore_options['body_bg_color'])) {
        $css_styles .= 'background-color: ' . $bookstore_options['body_bg_color'] . ';';
    }
    else {
        $css_styles .= 'background-color: #e5e5e5;';
    }
    if(isset($bookstore_options['body_bg_image']['url'])) {
        $css_styles .= 'background-image: url(' . $bookstore_options['body_bg_image']['url'] . ');';
        if(isset($bookstore_options['body_image_repeat'])) {
            if($bookstore_options['body_image_repeat'] == 'full') {
                $css_styles .= 'background-repeat: no-repeat;background-position: 0 0; background-size: cover;';
            }
            elseif($bookstore_options['body_image_repeat'] == 'tiled') {
                $css_styles .= 'background-repeat: repeat;';
            }
            elseif($bookstore_options['body_image_repeat'] == 'repeat-x') {
                $css_styles .= 'background-repeat: repeat-x;';
            }
            elseif($bookstore_options['body_image_repeat'] == 'repeat-y') {
                $css_styles .= 'background-repeat: repeat-y;';
            }
        }
    }
    $css_styles .= ' } ';

    $css_styles .= '.product-header {';
    if(isset($bookstore_options['shop_header_bg_img']['url']) && !empty($bookstore_options['shop_header_bg_img']['url'])) {
        $css_styles .= 'background: url(' . $bookstore_options['shop_header_bg_img']['url'] . ');';
    }
    if(isset($bookstore_options['shop_header_bg_color'])) {
        $css_styles .= 'background-color: ' . $bookstore_options['shop_header_bg_color'] . ';';
    }
    else {
        $css_styles .= 'background-color: #666;';
    }
    $css_styles .= ' } ';

    $css_styles .= '.page-header { ';
    if(isset($bookstore_options['page_header_image']['url'])) {
        $css_styles .= 'background: url(' . $bookstore_options['page_header_image']['url'] . ');';
    }
    if(isset($bookstore_options['page_header_bg_color'])) {
        $css_styles .= 'background-color: ' . $bookstore_options['page_header_bg_color'] . ';';
    }
    else {
        $css_styles .= 'background-color: #666;';
    }
    $css_styles .= ' } ';


    //Primary color settings
    //Button color
    $css_styles .= '.btn-primary, #back-to-top .btn { ';
    if(isset($bookstore_options['primary_color'])) {
        $css_styles .= 'background-color: ' . $bookstore_options['primary_color'] . ' !important;';
        $css_styles .= 'border-color: '. $bookstore_options['primary_color'] . ' !important;';
    }
    else {
        $css_styles .= 'background-color: #27ae61 !important;';
        $css_styles .= 'border-color: #27ae61 !important;';
    }
    if(isset($bookstore_options['primary_text_color'])) {
        $css_styles .= 'color: ' . $bookstore_options['primary_text_color'] . ' !important;';
    }
    else {
        $css_styles .= 'color:#fff !important;';
    }
    $css_styles .= '}';

    //Button hover color
    $css_styles .= '.btn-primary:hover, .btn-primary:focus, .btn-primary:active:focus, .btn-primary:active:hover,
       #back-to-top .btn:hover, #back-to-top .btn:active, #back-to-top .btn:focus { ';
    if(isset($bookstore_options['primary_hover_color'])) {
        $css_styles .= 'background-color: ' . $bookstore_options['primary_hover_color'] . ' !important;';
        $css_styles .= 'border-color: '. $bookstore_options['primary_hover_color'] . ';';
    }
    else {
        $css_styles .= 'background-color: #27ae61 !important;';
        $css_styles .= 'border-color: #27ae61 !important;';
    }
    if(isset($bookstore_options['primary_text_color'])) {
        $css_styles .= 'color: ' . $bookstore_options['primary_text_hover_color'] . ' !important;';
    }
    else {
        $css_styles .= 'color:#fff !important;';
    }
    $css_styles .= '}';

    $css_styles .= '.product-wrap .add-to-cart-btn a, .product-wrap .yith_compare_btn a, .product-wrap .yith-wcwl-add-to-wishlist a, .yith-wcwl-add-to-wishlist .woocommerce a.add_to_wishlist,
.product .single_add_to_cart_button, div.product .summary .yith-wcwl-add-to-wishlist a, .woocommerce div.product .summary .compare,
.woocommerce div.product .woocommerce-tabs ul.tabs li.active, .gridlist-toggle a:hover, .gridlist-toggle a.active,
.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt,
.woocommerce input.button.alt, .woocommerce #respond input#submit, .woocommerce a.button,
.woocommerce button.button, .woocommerce input.button,
.main-menu .vc-mm-h-sticky-wrapper.is-sticky .vc-transparent.vc-mm-menu-h, .main-menu .vc-nav-on-mobile, ul.post-categories li a,
.main-menu .vc-mm-mega-cont h3:hover, .main-menu .vc-mm-mega-cont h4:hover, .main-menu .vc-mm-mega-cont h5:hover, #bks-products-slider .vc_tta.vc_general li.vc_active a
{';
    if(isset($bookstore_options['primary_color'])) {
        $css_styles .= 'background-color: ' . $bookstore_options['primary_color'] . ' !important;';
    }
    else {
        $css_styles .= 'background-color: #27ae61 !important;';
    }
    if(isset($bookstore_options['primary_text_color'])) {
        $css_styles .= 'color: ' . $bookstore_options['primary_text_color'] . ' !important;';
    }
    else {
        $css_styles .= 'color:#fff !important;';
    }
    $css_styles .= '}';

    $css_styles .= '.product-wrap .add-to-cart-btn a:hover, .woocommerce button.single_add_to_cart_button:hover, .product-wrap .add-to-cart-btn a.added, .product-wrap .yith_compare_btn a:hover, .product-wrap .yith-wcwl-add-to-wishlist a:hover,
.product-wrap .yith-wcwl-wishlistaddedbrowse.show a, .product-wrap .yith-wcwl-wishlistexistsbrowse.show a, .product .single_add_to_cart_button:hover,
div.product .summary .yith-wcwl-add-to-wishlist a:hover, .woocommerce div.product .summary .compare:hover,
.yith-wcwl-wishlistaddedbrowse.show, .yith-wcwl-wishlistexistsbrowse.show, .catalog-image .yith-wcqv-button {';
    if(isset($bookstore_options['primary_hover_color'])) {
        $css_styles .= 'background-color: ' . $bookstore_options['primary_hover_color'] . ' !important;';
    }
    else {
        $css_styles .= 'background-color: #229955 !important;';
    }
    if(isset($bookstore_options['primary_text_hover_color'])) {
        $css_styles .= 'color: ' . $bookstore_options['primary_text_hover_color'] . ' !important;';
    }
    else {
        $css_styles .= 'color:#fff !important;';
    }
    $css_styles .= '}';

    //Border color
    $css_styles .= '.woocommerce #content div.product div.thumbnails a:hover, .woocommerce div.product div.thumbnails a:hover,
.woocommerce-page #content div.product div.thumbnails a:hover, .woocommerce-page div.product div.thumbnails a:hover,
.woocommerce .woocommerce-info, .product-wrap:hover, .main-menu .vc-mm-mega-cont h3, .main-menu .vc-mm-mega-cont h4,
.main-menu .vc-mm-mega-cont h5, .woocommerce .woocommerce-message, .bks-product-list-wrap .bks-products-list-container li:hover,
.main-menu .vc-mm-mega-cont .wpb_wrapper h3 {';
    if(isset($bookstore_options['primary_color'])) {
        $css_styles .= 'border-color: '. $bookstore_options['primary_color'] . ';';
    }
    else {
        $css_styles .= 'border-color: #27ae61;';
    }
    $css_styles .= '}';

    $css_styles .= '.woocommerce div.product .woocommerce-tabs ul.tabs li.active { ';
    if(isset($bookstore_options['primary_color'])) {
        $css_styles .= 'border: 2px solid '. $bookstore_options['primary_color'] . ';';
    }
    else {
        $css_styles .= 'border: 2px solid #27ae61;';
    }
    $css_styles .= '}';

    $css_styles .= '#bks-products-slider .vc_tta-tabs-container ul li.vc_active:after {';
    if(isset($bookstore_options['primary_color'])) {
        $css_styles .= 'border-color:' . $bookstore_options['primary_color'] . ' rgba(0,0,0,0) rgba(0,0,0,0) rgba(0,0,0,0);';
    }
    else {
        $css_styles .= 'border-color: #27ae61 rgba(0,0,0,0) rgba(0,0,0,0) rgba(0,0,0,0);';
    }
    $css_styles .= '}';

    //Background color
    $css_styles .= '.woocommerce .widget_price_filter .ui-slider .ui-slider-range, .bks-post-slider .post-grid .post-content .post-date {';
    if(isset($bookstore_options['primary_color'])) {
        $css_styles .= 'background-color: ' . $bookstore_options['primary_color'] . ' !important;';
    }
    else {
        $css_styles .= 'background-color: #27ae61 !important;';
    }
    $css_styles .= '}';

    $css_styles .= '.woocommerce .widget_price_filter .ui-slider .ui-slider-handle {';
    if(isset($bookstore_options['primary_color'])) {
        $css_styles .= 'border: 2px solid '. $bookstore_options['primary_color'] . ';';
    }
    else {
        $css_styles .= 'border: 2px solid #27ae61;';
    }
    $css_styles .= '}';

    //Border color and Text color
    $css_styles .= '.gridlist-toggle a { ';
    if(isset($bookstore_options['primary_color'])) {
        $css_styles .= 'color: '. $bookstore_options['primary_color'] . ';border: 2px solid ' . $bookstore_options['primary_color'] . ';';
    }
    else {
        $css_styles .= 'color: #27ae61;border: 2px solid #27ae61;';
    }
    $css_styles .= '}';

    $css_styles .= '.bks-post-slider .post-grid .post-content .post-date:after { ';
    if(isset($bookstore_options['primary_color'])) {
        $css_styles .= 'border-color: rgba(0,0,0,0) rgba(0,0,0,0) '. $bookstore_options['primary_color'] . ' rgba(0,0,0,0);';
    }
    else {
        $css_styles .= 'rgba(0,0,0,0) rgba(0,0,0,0) #229955 rgba(0,0,0,0);';
    }
    $css_styles .= '}';

    //Text color
    $css_styles .= '.woocommerce .woocommerce-info:before, .single .post-meta .author a,
    .woocommerce .woocommerce-message:before, .read-more, .bks-product-list-wrap .bks-products-list-container li .product-content .amount,
    .slick-dots li.slick-active button:before, .product-wrap span.price { ';
    if(isset($bookstore_options['primary_color'])) {
        $css_styles .= 'color: '. $bookstore_options['primary_color'] . '!important;';
    }
    else {
        $css_styles .= 'color: #27ae61!important;';
    }
    $css_styles .= '}';

     $css_styles .= 'ul.post-categories li a:after { ';
    if(isset($bookstore_options['primary_color'])) {
        $css_styles .= 'border-right-color: '. $bookstore_options['primary_color'] . ';';
    }
    else {
        $css_styles .= 'border-right-color: #27ae61;';
    }
    $css_styles .= '}';

    $css_styles .= '.pagination > .active > a, .pagination > .active > span, .pagination>.active>a, .pagination>.active>a:focus,
    .pagination>.active>a:hover, .pagination>.active>span, .pagination>.active>span:focus,
    .pagination>.active>span:hover {';
    if(isset($bookstore_options['primary_color'])) {
        $css_styles .= 'background-color: ' . $bookstore_options['primary_color'] . ' !important;';
        $css_styles .= 'border: 2px solid ' . $bookstore_options['primary_color'] . ' !important;';
    }
    else {
        $css_styles .= 'background-color: #27ae61 !important;';
        $css_styles .= 'border: 2px solid #27ae61 !important;';
    }
     if(isset($bookstore_options['primary_text_color'])) {
        $css_styles .= 'color: ' . $bookstore_options['primary_text_color'] . ' !important;';
    }
    else {
        $css_styles .= 'color:#fff !important;';
    }
    $css_styles .= '}';

    $css_styles .= '@media only screen and (max-width: 768px) { .vc-mm-menu-h .vc-nav-on-desktop, .vc-mm-menu-v .vc-nav-on-desktop,
            .vc-mm-menu-h .vc-nav-on-desktop .vc-mm-mega-cont, .vc-mm-menu-v .vc-nav-on-desktop .vc-mm-mega-cont { ';
    if(isset($bookstore_options['primary_color'])) {
        //$css_styles .= 'background: ' . $bookstore_options['primary_color'] . ' !important;';
    }
    else {
        //$css_styles .= 'background: #27ae61 !important;';
    }
    if(isset($bookstore_options['primary_text_color'])) {
        //$css_styles .= 'color: ' . $bookstore_options['primary_text_color'] . ' !important;';
    }
    else {
        //$css_styles .= 'color:#fff !important;';
    }
    $css_styles .= '} }';

    $css_styles .= '@media only screen and (max-width: 768px) { ';
    $css_styles .= '.vc-mm-menu-h .vc-nav-on-desktop > li:hover > a,
           .vc-mm-menu-v .vc-nav-on-desktop > li:hover > a { ';
    if(isset($bookstore_options['primary_hover_color'])) {
        $css_styles .= 'background-color: ' . $bookstore_options['primary_hover_color'] . ' !important;';
    }
    else {
        $css_styles .= 'background-color: #229955 !important;';
    }
    if(isset($bookstore_options['primary_text_hover_color'])) {
        $css_styles .= 'color: ' . $bookstore_options['primary_text_hover_color'] . ' !important;';
    }
    else {
        $css_styles .= 'color:#fff !important;';
    }
    $css_styles .= '}';
    $css_styles .= '.vc-mm-menu-h .vc-nav-on-desktop .vc-d-0 > .nav-link, .vc-mm-menu-v .vc-nav-on-desktop .vc-d-0 > .nav-link,
            .vc-mm-menu-h .vc-mm-child-title, .vc-mm-menu-v .vc-mm-child-title {';
    if(isset($bookstore_options['primary_hover_color'])) {
        $css_styles .= 'border-color: ' . $bookstore_options['primary_hover_color'] . ' !important;';
    }
    else {
        $css_styles .= 'border-color: #229955 !important;';
    }
    $css_styles .= '}';

    $css_styles .= '}'; //@media only screen and (max-width: 768px)

    //text hover color
    $css_styles .= '.read-more:hover { ';
    if(isset($bookstore_options['primary_hover_color'])) {
        $css_styles .= 'color: '. $bookstore_options['primary_hover_color'] . ';';
    }
    else {
        $css_styles .= 'color: #27ae61;';
    }
    $css_styles .= '}';

    //Secondary color settings
    $css_styles .= '.woocommerce div.product .woocommerce-tabs ul.tabs li {';
    if(isset($bookstore_options['secondary_color'])) {
        $css_styles .= 'background-color: ' . $bookstore_options['secondary_color'] . ' !important;';
    }
    else {
        $css_styles .= 'background-color:#fff !important;';
    }
    if(isset($bookstore_options['secondary_text_color'])) {
        $css_styles .= 'color: ' . $bookstore_options['secondary_text_color'] . ' !important;';
    }
    else {
        $css_styles .= 'color:#333 !important;';
    }
    $css_styles .= '}';

    if(isset($bookstore_options['currency_switcher']) && $bookstore_options['currency_switcher'] == 1) {
        $css_styles .= '.bks-cart-widget .minicart-button { ';
        $css_styles .= 'border-top-left-radius: 0px !important;
        border-bottom-left-radius: 0px !important;
        border-left: 0px;';
        $css_styles .= '}';
    }

    if(isset($bookstore_options['promo_bg_color'])) {
        $css_styles .= '.bks-promo { ';
        $css_styles .= 'background-color: ' . $bookstore_options['promo_bg_color'] . ';';
        $css_styles .= '}';
    }

    //Social icons
    $css_styles .= 'body .social-links li a .social-icon { ';
    if(isset($bookstore_options['s_icons_bg_color'])) {
        $css_styles .= 'background: ' . $bookstore_options['s_icons_bg_color'] . ';';
    }
    else {
        $css_styles .= 'background: #24a9e2;';
    }
    if(isset($bookstore_options['s_icons_color'])) {
        $css_styles .= 'color: ' . $bookstore_options['s_icons_color'] . ';';
    }
    else {
        $css_styles .= 'color: #ffffff;';
    }
    $css_styles .= '}';
    $css_styles .= 'body .social-links li a .social-icon:hover, body .social-links li a .social-icon:focus { ';
    if(isset($bookstore_options['s_icons_bg_hover_color'])) {
        $css_styles .= 'background: ' . $bookstore_options['s_icons_bg_hover_color'] . ';';
    }
    else {
        $css_styles .= 'background: #1e73be;';
    }
    if(isset($bookstore_options['s_icons_hover_color'])) {
        $css_styles .= 'color: ' . $bookstore_options['s_icons_hover_color'] . ';';
    }
    else {
        $css_styles .= 'color: #ffffff;';
    }
    $css_styles .= '}';
    $css_styles .= 'body .social-links li .social-icon, .social-icon:after { ';
    if(isset($bookstore_options['s_icons_type']) && $bookstore_options['s_icons_type'] == 1) {
        $css_styles .= '-webkit-border-radius: 50%;
                        -moz-border-radius: 50%;
                        -ms-border-radius: 50%;
                        -o-border-radius: 50%;
                        border-radius: 50%;';
    }
    $css_styles .= '}';

    if(empty($bookstore_options['slider_alias'])) {
        $css_styles .= '.feature-box-style1 { margin-top:0;z-index:1 }';
    }

    //fallback menu styles
    if(!class_exists('VC_MegaMenu')) {
        $css_styles .= 'nav.main-menu {
            clear: both;
            min-height: 45px;
            position: relative;
        }
        nav.main-menu .nav-menu li {
            display: inline-block;
            position: relative;
        }

        nav.main-menu .nav-menu li a {
            color: #fff;
            display: block;
            font-size: 15px;
            line-height: 1;
            padding: 15px 20px;
            text-decoration: none;
        }
        nav.main-menu .nav-menu > li:hover > a, nav.main-menu .nav-menu > li a:hover, nav.main-menu .nav-menu > li:focus > a, nav.main-menu .nav-menu > li a:focus {
            background-color: #229955;
            color: #fff;
        }

        nav.main-menu .nav-menu .sub-menu, .nav-menu .children {
            background-color: #fff;
            border-top: 0;
            padding: 0;
            position: absolute;
            left: -2px;
            z-index: 99999;
            height: 1px;
            width: 1px;
            overflow: hidden;
            clip: rect(1px, 1px, 1px, 1px);
        }

        .nav-menu .children li {
            padding: 0 30px;
        }

        nav.main-menu .nav-menu .sub-menu li:hover > a, nav.main-menu .nav-menu .children li:hover > a {
            background-color: #fff;
            color: #262626;
        }

        nav.main-menu ul.nav-menu ul a, .nav-menu ul ul a {
            color: #262626;
            margin: 0;
            width: 200px;
            border-bottom: 1px solid #e9e9e9;
        }

        nav.main-menu ul.nav-menu li:hover > ul, nav.main-menu .nav-menu ul li:hover > ul, nav.main-menu ul.nav-menu .focus > ul, nav.main-menu .nav-menu .focus > ul {
            clip: inherit;
            overflow: inherit;
            height: inherit;
            width: inherit;
        }

        nav.main-menu .nav-menu .sub-menu ul, nav.main-menu .nav-menu .children ul {
            border-left: 0;
            left: 100%;
            top: 0;
        }
        ';
    }

    //custom css styles
    if(isset($bookstore_options['bookstore_custom_css'])) {
        $css_styles .= trim($bookstore_options['bookstore_custom_css']);
    }

    if(function_exists('bookstore_compress_css')) {
        $output_css = bookstore_compress_css($css_styles);
    }
    else {
        $output_css = $css_styles;
    }

    return $output_css;

}
