<?php
/**
 * Theme setup and Register WordPress features
 * @package   bookstore
 * @author    AcmeeDesign
 * @link      http://acmeedesign.com
 * @since     1.0
 */
if ( ! function_exists( 'bookstore_theme_setup' ) ) {
    function bookstore_theme_setup(){
        //Add Theme Supports
        add_theme_support( 'post-formats', array( 'audio', 'quote', 'video' ) );
        add_theme_support( 'post-thumbnails' );
        add_theme_support( 'automatic-feed-links' );
        add_theme_support( 'title-tag' );
        add_theme_support( 'woocommerce' );
        //Maximum width for media
        if ( ! isset( $content_width ) ){ $content_width = 1200; }

        //Load Translation
        load_theme_textdomain( 'bookstore', get_template_directory() . '/languages' );

        //Register Menu Locations
        register_nav_menus( array(
                'topbar' => esc_html__( 'Topbar Navigation', 'bookstore' ),
        ) );
        register_nav_menus( array(
                'primary' => esc_html__( 'Primary Navigation', 'bookstore' ),
        ) );

        if(function_exists('vc_set_default_editor_post_types')) {
          vc_set_default_editor_post_types( array('page') );
        }

        //adding new woocommerce 3.0 features
        add_theme_support( 'wc-product-gallery-zoom' );
        add_theme_support( 'wc-product-gallery-lightbox' );
        add_theme_support( 'wc-product-gallery-slider' );

    }
}
add_action( 'after_setup_theme', 'bookstore_theme_setup');

if ( ! function_exists( 'bookstore_theme_image_sizes' ) ) {
    function bookstore_theme_image_sizes() {
        add_image_size('bookstore_img_banner', 370, 250, true);
        add_image_size('bookstore_product_thumb', 216, 265, true);
        add_image_size('bookstore_product_full', 555, 600, true);
        add_image_size('bookstore_post_slider_thumb', 350, 140, true);
        add_image_size('bookstore_blog_thumb', 830, 340, true);
    }
}
bookstore_theme_image_sizes();

function bookstore_content_width() {
    $GLOBALS['content_width'] = apply_filters( 'bookstore_content_width', 1170 );
}
add_action( 'after_setup_theme', 'bookstore_content_width', 0 );


/**
 * Register widgets area.
 */
add_action( 'widgets_init', 'bookstore_widgets_init' );
if ( ! function_exists( 'bookstore_widgets_init' ) ) {
    function bookstore_widgets_init() {

        register_sidebar( array(
                'name'          => esc_html__( 'Blog Sidebar', 'bookstore' ),
                'id'            => 'blog-sidebar',
                'description'   => 'Sidebar for blog page template.',
                'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                'after_widget'  => '</aside>',
                'before_title'  => '<h3 class="widget-title">',
                'after_title'   => '</h3>',
        ) );
        register_sidebar( array(
                'name'          => esc_html__( 'Header Widget', 'bookstore' ),
                'id'            => 'header-sidebar',
                'description'   => 'Widget for header on right.',
                'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                'after_widget'  => '</aside>',
                'before_title'  => '<h3 class="widget-title">',
                'after_title'   => '</h3>',
        ) );
        register_sidebar( array(
                'name'          => esc_html__( 'Page Sidebar', 'bookstore' ),
                'id'            => 'pages-sidebar',
                'description'   => 'Sidebar for default pages.',
                'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                'after_widget'  => '</aside>',
                'before_title'  => '<h3 class="widget-title">',
                'after_title'   => '</h3>',
        ) );
        register_sidebar( array(
                'name'          => esc_html__( 'Shop Sidebar', 'bookstore' ),
                'id'            => 'shop-sidebar',
                'description'   => 'Sidebar for Shop page template.',
                'before_widget' => '<div id="%1$s" class="widget %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h3 class="widget-title">',
                'after_title'   => '</h3>',
        ) );
        register_sidebar( array(
                'name'          => esc_html__( 'Footer Col 1', 'bookstore' ),
                'id'            => 'footer-col1',
                'description'   => 'Sidebar for column 1 in footer.',
                'before_widget' => '<div id="%1$s" class="widget t3-module module %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h2 class="widget-title">',
                'after_title'   => '</h2>',
        ) );
        register_sidebar( array(
                'name'          => esc_html__( 'Footer Col 2', 'bookstore' ),
                'id'            => 'footer-col2',
                'description'   => 'Sidebar for column 2 in footer.',
                'before_widget' => '<div id="%1$s" class="widget t3-module module %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h2 class="widget-title">',
                'after_title'   => '</h2>',
        ) );
        register_sidebar( array(
                'name'          => esc_html__( 'Footer Col 3', 'bookstore' ),
                'id'            => 'footer-col3',
                'description'   => 'Sidebar for column 3 in footer.',
                'before_widget' => '<div id="%1$s" class="widget t3-module module %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h2 class="widget-title">',
                'after_title'   => '</h2>',
        ) );
        register_sidebar( array(
                'name'          => esc_html__( 'Footer Col 4', 'bookstore' ),
                'id'            => 'footer-col4',
                'description'   => 'Sidebar for column 4 in footer.',
                'before_widget' => '<div id="%1$s" class="widget t3-module module %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h2 class="widget-title">',
                'after_title'   => '</h2>',
        ) );
    }
}

//Register theme required scripts and css
add_action('wp_enqueue_scripts', 'bookstore_register_scripts', 999);
if ( ! function_exists( 'bookstore_register_scripts' ) ) {
    function bookstore_register_scripts() {
        wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/assets/css/font-awesome/css/font-awesome.min.css' );
        wp_enqueue_style( 'booststrap-css', get_template_directory_uri() . '/assets/css/bootstrap.min.css');
        wp_enqueue_style( 'bookstore-com-styles', get_template_directory_uri() . '/assets/css/common.css');
        wp_enqueue_style( 'bookstore-custom-styles', get_template_directory_uri() . '/assets/css/styles.css');

        //adding custom styles data
        if(function_exists('bookstore_customCSS')) {
            $custom_styles = bookstore_customCSS();
            wp_add_inline_style( 'bookstore-custom-styles', $custom_styles );
        }
        if( is_single() && get_option( 'thread_comments' ) ){
                wp_enqueue_script( 'comment-reply' );
        }
        wp_enqueue_script( 'html5shiv', get_template_directory_uri() . '/assets/js/html5.js' );
        wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.min.js', array( 'jquery' ) );
        wp_script_add_data( 'html5shiv', 'conditional', 'lt IE 9' );

    }
}


add_filter('wp_list_categories', 'bookstore_add_span_cat_count');
if ( ! function_exists( 'bookstore_add_span_cat_count' ) ) {
    function bookstore_add_span_cat_count($links) {
        $links = str_replace('</a> (', '</a> <span class="post-count">(', $links);
        $links = str_replace(')', ')</span>', $links);
        return $links;
    }
}

add_filter( 'get_search_form', 'bookstore_custom_search_form' );
if ( ! function_exists( 'bookstore_custom_search_form' ) ) {
    function bookstore_custom_search_form( $form ) {
        $form = '<form role="search" method="get" id="searchform" class="searchform" action="' . home_url( '/' ) . '" >

        <input type="text" value="' . get_search_query() . '" name="s" id="s" placeholder="' . esc_html_e( 'Search',  'bookstore' ) . ' " />
        <button type="submit" class="btn btn-primary">
                <i class="fa fa-search"></i>
        </button>
        </form>';

        return $form;
    }
}

add_filter( 'woocommerce_sale_flash', 'bookstore_custom_sales_badge' );
if (!function_exists('bookstore_custom_sales_badge')) {
    function bookstore_custom_sales_badge() {
        $sale_text = '<span class="on-sale">' . esc_attr('Sale!', 'bookshop') . '</span>';
        return wp_kses_post($sale_text);
    }
}

//Set custom image size for woocommerce product images
add_action( 'after_switch_theme', 'bookstore_wc_custom_image_dimensions', 1 );
if ( ! function_exists( 'bookstore_wc_custom_image_dimensions' ) ) {
    function bookstore_wc_custom_image_dimensions() {
        global $pagenow;

        if ( ! isset( $_GET['activated'] ) || $pagenow != 'themes.php' ) {
            return;
        }

        $catalog = array(
            'width'     => '247',
            'height'    => '300',
            'crop'      => 1
        );

        $single = array(
            'width'     => '350',
            'height'    => '450',
            'crop'      => 1
        );

        $thumbnail = array(
            'width'     => '100',
            'height'    => '128',
            'crop'      => 1
        );

        // Image sizes
        update_option( 'shop_catalog_image_size', $catalog );       // Product category thumbs
        update_option( 'shop_single_image_size', $single );         // Single product image
        update_option( 'shop_thumbnail_image_size', $thumbnail );   // Image gallery thumbs
    }
}

add_action( 'init', 'bookstore_remove_wc_breadcrumbs' );
if ( ! function_exists( 'bookstore_remove_wc_breadcrumbs' ) ) {
    function bookstore_remove_wc_breadcrumbs() {
        remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
    }
}

// Continue Shopping button
add_action('woocommerce_proceed_to_checkout', 'bookstore_cart_continue_shopping_btn', 20);
if ( ! function_exists( 'bookstore_cart_continue_shopping_btn' ) ) {
    function bookstore_cart_continue_shopping_btn(){
        $output = '<a href="'.esc_url(get_permalink( wc_get_page_id( 'shop' ) )).'" class="button button-secondary continue_shoping">'.esc_html__('Continue Shopping', 'bookstore').'</a>';
        echo wp_kses_post($output);
    }
}

// Ensure cart contents update when products are added to the cart via AJAX (place the following in functions.php)
add_filter( 'woocommerce_add_to_cart_fragments', 'bookstore_wc_header_add_to_cart_fragment' );
if ( ! function_exists( 'bookstore_wc_header_add_to_cart_fragment' ) ) {
    function bookstore_wc_header_add_to_cart_fragment( $fragments ) {
            ob_start();

                        if(function_exists('bookstore_woo_cart_count')) {
                            echo wp_kses_post( bookstore_woo_cart_count() );
                        }
            $fragments['a.cart-content'] = ob_get_clean();

            return $fragments;
    }
}

//Show bookstore_wp_breadcrumbs for bookstore
if ( ! function_exists( 'bookstore_breadcrumb' ) ) {
    function bookstore_breadcrumb($class) {
        global $post;
        $bread_start_tag = '<div class="' . $class . ' bks-breadcrumb">
        <div class="container">
            <h1>';
        $bread_close_h1_tag = '</h1>';
        $bread_end_tag = '</div>
    </div>';
        $output = "";
        $output .= $bread_start_tag;
        if ((function_exists('is_woocommerce') && is_woocommerce()) || (function_exists('is_shop') && is_shop())) {
            $output .= woocommerce_page_title(false);
        }
        else if (!is_front_page() && is_home()) {
            $output .= wp_title('', false);
        }
        else if (is_page()) {
            $output .= wp_title('', false);
        }
        else {
            $output .= get_the_title();
        }
        $output .= $bread_close_h1_tag;
            $bcargs = array(
                'delimiter' => '',
                'wrap_before' => '<ul class="breadcrumb clearfix">',
                'wrap_after' => '</ul>',
                'before' => '<li>',
                'after' => '</li>'
            );
         $output .=bookstore_wp_breadcrumbs( $bcargs );
         $output .=$bread_end_tag;
         return $output;
    }
}

if ( ! function_exists( 'bookstore_list_blog_comments' ) ) {
    function bookstore_list_blog_comments() {
        wp_list_comments( 'avatar_size=50&callback=bookstore_custom_comments_reply&short_ping=true,' );
    }
}

//callback function for wp_list_comments()
if ( ! function_exists( 'bookstore_custom_comments_reply' ) ) {
    function bookstore_custom_comments_reply($comment, $args, $depth) {
        $GLOBALS['comment'] = $comment;
        extract($args, EXTR_SKIP);

        if ( 'div' == $args['style'] ) {
                $tag = 'div';
                $add_below = 'comment';
        } else {
                $tag = 'li';
                $add_below = 'div-comment';
        }
    ?>
        <<?php echo esc_attr($tag); ?> <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ) ?> id="comment-<?php comment_ID() ?>">
        <?php if ( 'div' != $args['style'] ) : ?>
        <div id="div-comment-<?php comment_ID() ?>" class="comment-body">
        <?php endif; ?>

            <div class="comment-author left">
            <?php if ( $args['avatar_size'] != 0 ) echo get_avatar( $comment, $args['avatar_size'] ); ?>
            </div>

            <div class="comment-data">
                <?php if ( $comment->comment_approved == '0' ) : ?>
                        <em class="comment-awaiting-moderation"><?php esc_html__('Your comment is awaiting moderation.', 'bookstore'); ?></em>
                        <br />
                <?php endif; ?>

                        <div class="comment-meta commentmetadata"><i class="fa fa-clock-o"></i> <a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ); ?>">
                        <?php
                                /* translators: 1: date, 2: time */
                                printf( esc_attr('%1$s at %2$s'), get_comment_date(),  get_comment_time() ); ?></a><?php edit_comment_link( esc_attr( 'Edit' ), '  ', '' );
                        ?>
                            <i class="fa fa-user"></i> <?php comment_author_link(); ?>
                </div>

                <?php comment_text(); ?>

                <div class="reply">
                <?php comment_reply_link( array_merge( $args, array( 'add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
                </div>
            </div>
        <?php if ( 'div' != $args['style'] ) : ?>
        </div>
        <?php
        endif;
    }
}

add_filter( 'wp_title', 'bookstore_custom_shop_archive_title' );
if ( ! function_exists( 'bookstore_custom_shop_archive_title' ) ) {
    function bookstore_custom_shop_archive_title( $title ) {
        global $bookstore_options;
        if ( function_exists('is_shop') && is_shop() && isset($bookstore_options['shop-title']) ) {
            return str_replace( esc_html( 'Products', 'woocommerce' ), $bookstore_options['shop-title'], $title );
        }

        return $title;
    }
}

add_filter( 'body_class', 'bookstore_extra_classes' );
if ( ! function_exists( 'bookstore_extra_classes' ) ) {
    function bookstore_extra_classes( $classes ) {
        global $bookstore_options;
        if(isset($bookstore_options['layout_style']) && $bookstore_options['layout_style'] == "boxed") {
            $classes[] = 'boxed-layout';
        }
        // return the $classes array
        return $classes;
    }
}

//Register custom post type for testimonials
if (class_exists('BOOKSTORE_CPT')) {
    $testimonials = new BOOKSTORE_CPT(
            array(
                'post_type_name' => 'bks_testmonials', //theme name abbrevation used because register posts type do not accept more than 20 characters
                'singular' => 'Testimonial',
                'plural' => 'Testimonial',
                'slug' => 'bookstore_testmonials'
            ),
            array(
            'supports' => array('title', 'editor', 'thumbnail', 'comments'
                )
    ));

    $testimonials->register_taxonomy(
            array(
                'taxonomy_name' => 'testimonial_categories',
                'singular' => 'Categories',
                'plural' => 'Categories',
                'slug' => 'Category'
            ));

}

if ( ! function_exists( 'bookstore_options' ) ) {
    function bookstore_options() {
        global $bookstore_options;
        return $bookstore_options;
    }
}

//add_filter( 'woocommerce_sale_flash', 'bookstore_custom_sales_badge' );
if (!function_exists('bookstore_custom_sales_badge')) {
    function bookstore_custom_sales_badge() {
        $sale_text = '<span class="on-sale">' . esc_attr('Sale!', 'bookstore') . '</span>';
        return wp_kses_post($sale_text);
    }
}

remove_action('woocommerce_after_shop_loop', 'woocommerce_pagination', 10);

add_action('woocommerce_after_shop_loop', 'bookstore_woocommerce_pagination', 10);
if (!function_exists('bookstore_woocommerce_pagination')) {
    function bookstore_woocommerce_pagination(){
        if(function_exists('bookstore_posts_nav')) {
            bookstore_posts_nav();
        }
    }
}

//Disable VC frontend editing
if(function_exists('vc_disable_frontend')) {
    vc_disable_frontend();
}

add_filter('vc_mm_nav_css', '__return_false');

//properly enqueue css and scripts that is improperly enqueued
add_action('wp_enqueue_scripts', 'bookstore_add_attr' );
if (!function_exists('bookstore_add_attr')) {
    function bookstore_add_attr() {
        global $wp_styles;
        if(isset($wp_styles)) {
           $wp_styles->add('vc-mm', '/wp-content/plugins/vc-mega-menu/assets/frontend/vc-mm.css');
           $wp_styles->add('font-awesome', '/wp-content/plugins/js_composer/assets/lib/bower/font-awesome/css/font-awesome.min.css');
           $wp_styles->add('vc_google_fonts_abril_fatfaceregular', '//fonts.googleapis.com/css?family=Abril+Fatface%3Aregular&#038');
           $wp_styles->enqueue(array('vc-mm'));
           $wp_styles->enqueue(array('font-awesome'));
           $wp_styles->enqueue(array('vc_google_fonts_abril_fatfaceregular'));
        }
    }
}

add_action('init', 'bookstore_add_product_author_selection', 999 );
if(!function_exists('bookstore_add_product_author_selection')) {
  function bookstore_add_product_author_selection() {
      add_post_type_support( 'product', 'author' );
  }
}

add_action('woocommerce_single_product_summary', 'bookstore_add_author_link');
if (!function_exists('bookstore_add_author_link')) {
    function bookstore_add_author_link() {
        global $bookstore_options;
            if(!empty($bookstore_options['show_author_link_single_product'])) {
        ?>
        <div class="book-by-author">
    <a class="book-author" href="<?php echo esc_url( home_url('/') ); ?>author/<?php the_author_meta( 'display_name' ); ?>/?post_type=product"><?php esc_html_e('By', 'bookstore'); ?> <?php the_author_meta( 'display_name' ); ?></a>
  </div>
    <?php
            }
    }
}

add_filter( 'loop_shop_per_page','bookstore_products_per_page',20);
function bookstore_products_per_page(){
  global $bookstore_options;
  if(isset($bookstore_options['shop_products_count']) && is_numeric($bookstore_options['shop_products_count'])) {
    return $bookstore_options['shop_products_count'];
  }
  else
  return 12;
}

//add_filter( 'woocommerce_single_product_image_gallery_classes','bookstore_single_product_image_class',20);
function bookstore_single_product_image_class($product_image_class) {
  $product_image_class[] = 'col-sm-3';
  return $product_image_class;
}
