<?php

/**
 * Check if WooCommerce is active
 **/
if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {

    /**
     * WC_List_Grid class
     **/
    if ( ! class_exists( 'BKS_WC_List_Grid' ) ) {

            class BKS_WC_List_Grid {

                    public function __construct() {
                            // Hooks
                            add_action( 'wp' , array( $this, 'setup_gridlist' ) , 20);

                            // Init settings
                            $this->settings = array(
                                    array(
                                            'name' 	=> esc_html__( 'Default catalog view', 'bookstore' ),
                                            'type' 	=> 'title',
                                            'id' 	=> 'wc_glt_options'
                                    ),
                                    array(
                                            'name' 		=> esc_html__( 'Default catalog view', 'bookstore' ),
                                            'desc_tip' 	=> esc_html__( 'Display products in grid or list view by default', 'bookstore' ),
                                            'id' 		=> 'bookstore_wc_glt_default',
                                            'type' 		=> 'select',
                                            'options' 	=> array(
                                                    'grid'  => esc_html__( 'Grid', 'bookstore' ),
                                                    'list' 	=> esc_html__( 'List', 'bookstore' )
                                            )
                                    ),
                                    array( 'type' => 'sectionend', 'id' => 'wc_glt_options' ),
                            );

                            // Default options
                            add_option( 'bookstore_wc_glt_default', 'grid' );

                            // Admin
                            add_action( 'woocommerce_settings_image_options_after', array( $this, 'admin_settings' ), 20 );
                            add_action( 'woocommerce_update_options_catalog', array( $this, 'save_admin_settings' ) );
                            add_action( 'woocommerce_update_options_products', array( $this, 'save_admin_settings' ) );
                    }

                    /*-----------------------------------------------------------------------------------*/
                    /* Class Functions */
                    /*-----------------------------------------------------------------------------------*/

                    function admin_settings() {
                            woocommerce_admin_fields( $this->settings );
                    }

                    function save_admin_settings() {
                            woocommerce_update_options( $this->settings );
                    }

                    // Setup
                    function setup_gridlist() {
                            if ( is_shop() || is_product_category() || is_product_tag() || is_product_taxonomy() ) {
                                    add_action( 'wp_enqueue_scripts', array( $this, 'setup_scripts_script' ), 20);
                                    add_action( 'woocommerce_before_shop_loop', array( $this, 'gridlist_toggle_button' ), 30);
                                    add_action( 'woocommerce_after_shop_loop_item', array( $this, 'gridlist_buttonwrap_open' ), 9);
                                    add_action( 'woocommerce_after_shop_loop_item', array( $this, 'gridlist_buttonwrap_close' ), 11);
                                    add_action( 'woocommerce_after_shop_loop_item', array( $this, 'gridlist_hr' ), 30);
                                    add_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_single_excerpt', 5);
                                    add_action( 'woocommerce_after_subcategory', array( $this, 'gridlist_cat_desc' ) );
                            }
                    }

                    // Scripts 
                    function setup_scripts_script() {
                            wp_enqueue_script( 'js_cookie', get_template_directory_uri() . '/assets/js/jquery.cookie.min.js', array( 'jquery' ) );
                            wp_enqueue_script( 'grid-list-scripts', get_template_directory_uri() . '/assets/js/jquery.gridlistview.min.js', array( 'jquery' ) );
                            add_action( 'wp_footer', array( $this, 'gridlist_set_default_view' ) );
                    }

                    // Toggle button
                    function gridlist_toggle_button() {
                            ?>
                                    <nav class="gridlist-toggle">
                                            <a href="#" id="grid" title="<?php esc_html_e('Grid view', 'bookstore'); ?>"><span class="fa fa-th-large"></span> <em><?php esc_html_e( 'Grid view', 'bookstore' ); ?></em></a><a href="#" id="list" title="<?php esc_html_e('List view', 'bookstore'); ?>"><span class="fa fa-th-list"></span> <em><?php esc_html_e( 'List view', 'bookstore' ); ?></em></a>
                                    </nav>
                            <?php
                    }

                    // Button wrap
                    function gridlist_buttonwrap_open() {
                            ?>
                                    <div class="gridlist-buttonwrap">
                            <?php
                    }
                    function gridlist_buttonwrap_close() {
                            ?>
                                    </div>
                            <?php
                    }

                    // hr
                    function gridlist_hr() {
                            ?>
                                    <hr />
                            <?php
                    }

                    function gridlist_set_default_view() {
                            $default = get_option( 'bookstore_wc_glt_default' );
                            $default_val = (empty($default)) ? "grid" : $default;
                            ?>
                                    <script>
                                            if (jQuery.cookie( 'gridcookie' ) == null) {
                                            jQuery( 'div.products' ).addClass( '<?php echo esc_js($default_val); ?>' );
                                            jQuery( '.gridlist-toggle #<?php echo esc_js($default_val); ?>' ).addClass( 'active' );
                                        }
                                    </script>
                            <?php
                    }

                    function gridlist_cat_desc( $category ) {
                            global $woocommerce;
                            ?>
                            <div itemprop="description">
                            <?php echo wp_kses_post($category->description); ?>
                            </div>
<?php
                    }
            }

            $WC_List_Grid = new BKS_WC_List_Grid();
    }
}
