<?php
/*
 * @package   bookstore
 * @author    AcmeeDesign
 * @link      http://acmeedesign.com
 * @since     1.0
 */

function bookstore_get_image_url($id, $size = "full") {
    global $wpdb;
    if(is_numeric($id)) {
        $imageAttachment = wp_get_attachment_image_src( $id, $size );
        return $imageAttachment[0];
    }
}

function bookstore_clean_font_size($fontsize) {
    $fontsize = trim($fontsize);
    if(!is_numeric($fontsize)) {
        return str_replace('px', '', $fontsize);
    }
    else {
        return $fontsize;
    }
}

function bookstore_get_ph_image($image) {
    if(!empty($image)) {
        $output = "<img src='" . get_template_directory_uri() . "/assets/images/placeholders/" . $image . "' alt='placeholder' />" ;
        return wp_kses_post($output);
    }
}

function bookstore_get_terms_list($taxonamy) {
        $args = array(
            'orderby'           => 'name',
            'order'             => 'ASC',
            'hide_empty'        => false,
            //'parent' => 0
         );

        $terms = get_terms($taxonamy, $args);
        $terms_array['Select'] = '';
        if(!empty($terms)) {
            foreach($terms as $term) {
                if(!is_object($term)) {
                    continue;
                }
                $terms_array[$term->name] =  $term->term_id;
            }
        }
        return $terms_array;
}

/*Custom excerpt length function
 * @return excerpt with formatting
 */
function bookstore_custom_excerpt($excerpt_length = 55, $id = false, $echo = true) {

    $text = '';

    if($id) {
          $the_post = & get_post( $my_id = $id );
          $text = ($the_post->post_excerpt) ? $the_post->post_excerpt : $the_post->post_content;
    } else {
          global $post;
          $text = ($post->post_excerpt) ? $post->post_excerpt : get_the_content('');
    }

          $text = strip_shortcodes( $text );
          $text = apply_filters('the_content', $text);
          $text = str_replace(']]>', ']]&gt;', $text);
          $text = strip_tags($text);

          $excerpt_more = ' ' . '...';
          $words = preg_split("/[\n\r\t ]+/", $text, $excerpt_length + 1, PREG_SPLIT_NO_EMPTY);
          if ( count($words) > $excerpt_length ) {
                  array_pop($words);
                  $text = implode(' ', $words);
                  $text = $text . $excerpt_more;
          } else {
                  $text = implode(' ', $words);
          }
  if($echo)
      echo apply_filters('the_content', $text);
  else
  return $text;
}

/*Custom excerpt length function
 * @return without formatting
 */
function bookstore_get_excerpt($excerpt_length = 55, $id = false, $echo = false) {
    return bookstore_custom_excerpt_length($excerpt_length, $id, $echo);
}

function bookstore_get_terms($id, $taxonamy) {
    $product_terms = get_the_terms( $id, $taxonamy );
    $pr_i = 1;
    $output = "";
    if(!empty($product_terms)) {
        foreach ($product_terms as $product_term) {
            $output = $product_term->name;
            if($pr_i != 1) $output .= ', ';
            $pr_i++;
        }
    }

    return $output;

}

//CSS compression
function bookstore_compress_css($css) {
    $cssContents = "";
    // Remove comments
    $cssContents = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $css);
    // Remove space after colons
    $cssContents = str_replace(': ', ':', $cssContents);
    // Remove whitespace
    $cssContents = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $cssContents);
    return $cssContents;
}

function bookstore_get_file_url_ext($url) {
    $ext = parse_url($url, PHP_URL_PATH);
    if (strpos($ext,'.') !== false) {
        $basename = explode('.', basename($ext));
        return $basename[1];
    }
}

function bookstore_get_domain_name($url) {
    $parse_url = parse_url($url);
    $hostname = explode('.', $parse_url['host']);
    return $hostname;
}

//Pagination for blog posts
function bookstore_posts_nav() {

    $before = "<li";
    $after = "</li>";
    $output = "";
    if( is_singular() )
            return;

    global $wp_query;

    /** Stop execution if there's only 1 page */
    if( $wp_query->max_num_pages <= 1 )
            return;

    $paged = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;
    $max   = intval( $wp_query->max_num_pages );

    /**	Add current page to the array */
    if ( $paged >= 1 )
            $links[] = $paged;

    /**	Add the pages around the current page to the array */
    if ( $paged >= 3 ) {
            $links[] = $paged - 1;
            $links[] = $paged - 2;
    }

    if ( ( $paged + 2 ) <= $max ) {
            $links[] = $paged + 2;
            $links[] = $paged + 1;
    }

    $output .= '<div class="pagination-wrap"><ul class="pagination">';

    /**	Previous Post Link */
    if ( get_previous_posts_link() ) {
        $output .= $before . '>' . get_previous_posts_link('Prev') . $after;
    }

    /**	Link to first page, plus ellipses if necessary */
    if ( ! in_array( 1, $links ) ) {
            $class = 1 == $paged ? ' class="active"' : '';
            $output .= $before . $class . '><a href="' . esc_url(get_pagenum_link(1)) . '">1</a>' . $after;
            //printf( $before . '%s><a href="%s">%s</a>' . $after . "\n", $class, esc_url( get_pagenum_link( 1 ) ), '1' );

            if ( ! in_array( 2, $links ) )
                    $output .= $before . '>...' . $after;
    }

    /**	Link to current page, plus 2 pages in either direction if necessary */
    sort( $links );
    foreach ( (array) $links as $link ) {
            $class = $paged == $link ? ' class="active"' : '';
            $output .= $before . $class . '><a href="' . esc_url( get_pagenum_link( $link )) . '">' . $link . '</a>' . $after;
            //printf( $before . '%s><a href="%s">%s</a>' . $after . "\n", $class, esc_url( get_pagenum_link( $link ) ), $link );
    }

    /**	Link to last page, plus ellipses if necessary */
    if ( ! in_array( $max, $links ) ) {
            if ( ! in_array( $max - 1, $links ) )
                    $output .= $before . '>...' . $after . "\n";

            $class = $paged == $max ? ' class="active"' : '';
            $output .= $before . $class . '><a href="' . esc_url( get_pagenum_link( $max )) . '">' . $max . '</a>' . $after;
            //printf( $before . '%s><a href="%s">%s</a>' . $after . "\n", $class, esc_url( get_pagenum_link( $max ) ), $max );
    }

    /**	Next Post Link */
    if ( get_next_posts_link() ) {
        $output .= $before . '>' . get_next_posts_link('Next') . $after;
    }
            //printf( $before . '>%s' . $after . "\n", get_next_posts_link('Next') );

    $output .= '</ul></div>';

    echo wp_kses_post($output);
}

function bookstore_get_cart_url() {
    if ( class_exists( 'WooCommerce' ) ) {
        global $woocommerce;
        return esc_url($woocommerce->cart->get_cart_url());
    }
}

//Custom woocommerce mini cart items
function bookstore_woo_cart_count($items = true, $items_label = false, $cart_total = false) {
    if ( class_exists( 'WooCommerce' ) ) {
        $output = "<a class='cart-content' href='" . WC()->cart->get_cart_url() . "' title='" . esc_html__( 'View your shopping cart', 'bookstore' ) . "'>";
        if($items == true && $items_label == true) {
            $output .= "<span class='cart_items'>" . sprintf (_n( '%d item', '%d items', WC()->cart->get_cart_contents_count(), 'bookstore' ), WC()->cart->get_cart_contents_count() ) . "</span>";
        }
        elseif($items == true && $items_label == false) {
            $output .= "<span class='cart_items'>" . WC()->cart->get_cart_contents_count() . "</span>";
        }
        if($cart_total == true) {
            $output .= "<span class='cart_total'>" . WC()->cart->get_cart_total() . "</span>";
        }
        $output .= "</a>";

        return wp_kses_post($output);
    }
}

// Custom Breadcrumbs fn
function bookstore_wp_breadcrumbs( $settings = array() ) {

    // Settings
    $settings = array(
        'wrap_before' => '<ul class="breadcrumb clearfix">',
        'wrap_after' => '</ul>',
        'before' => '<li>',
        'after' => '</li>',
        'separator' => '',
     );
    $before = str_replace('>', '', $settings['before']);
    $after = $settings['after'];
    $breadcrums_id      = 'breadcrumbs';
    $breadcrums_class   = 'breadcrumbs';
    $home_title         = 'Home';
    $output = "";

    // If you have any custom post types with custom taxonomies, put the taxonomy name below (e.g. product_cat)
    $custom_taxonomy    = 'product_cat';

    // Get the query & post information
    global $post,$wp_query;

    $parents = "";
    // Do not display on the homepage
    if ( !is_front_page() ) {

        // Build the breadcrumbs
        $output .= $settings['wrap_before'];

        // Home page
        $output .= $before . ' class="item-home"><a class="bread-link bread-home" href="' . get_home_url() . '" title="' . $home_title . '">' . $home_title . '</a>' . $after;

        if(!empty($settings['separator'])) {
            $output .= $before . ' class="separator separator-home"> ' . $settings['separator'] . $after;
        }

        if (is_home()) {
            $output .= $before . ' class="item-current item-blog"><strong class="blog-current blog-archive">' . wp_title('', false) . '</strong>' . $after;
        }

        else if ( is_archive() && !is_tax() && !is_category() && !is_tag() ) {

            $output .= $before . ' class="item-current item-archive"><strong class="bread-current bread-archive">' . post_type_archive_title('', false) . '</strong>' . $after;

        } else if ( is_archive() && is_tax() && !is_category() && !is_tag() ) {

            // If post is a custom post type
            $post_type = get_post_type();

            // If it is a custom post type display name and link
            if($post_type != 'post') {

                $post_type_object = get_post_type_object($post_type);
                $post_type_archive = get_post_type_archive_link($post_type);

                $output .= $before . ' class="item-cat item-custom-post-type-' . $post_type . '"><a class="bread-cat bread-custom-post-type-' . $post_type . '" href="' . $post_type_archive . '" title="' . $post_type_object->labels->name . '">' . $post_type_object->labels->name . '</a>' . $after;

                if(!empty($settings['separator'])) {
                    $output .= $before . ' class="separator">' . $settings['separator'] . $after;
                }

            }

            $custom_tax_name = get_queried_object()->name;
            $output .= $before . ' class="item-current item-archive"><strong class="bread-current bread-archive">' . $custom_tax_name . '</strong>' . $after;

        } else if ( is_single() ) {

            // If post is a custom post type
            $post_type = get_post_type();

            // If it is a custom post type display name and link
            if($post_type != 'post') {

                $post_type_object = get_post_type_object($post_type);
                $post_type_archive = get_post_type_archive_link($post_type);

                $output .= $before . ' class="item-cat item-custom-post-type-' . $post_type . '"><a class="bread-cat bread-custom-post-type-' . $post_type . '" href="' . $post_type_archive . '" title="' . $post_type_object->labels->name . '">' . $post_type_object->labels->name . '</a>' . $after;

                if(!empty($settings['separator'])) {
                    $output .= $before . ' class="separator">' . $settings['separator'] . $after;
                }

            }

            // Get post category info
            $category = get_the_category();

            if(!empty($category)) {

                // Get last category post is in
                $category_array = array_values($category);
                $last_category = end($category_array);

                // Get parent any categories and create array
                $get_cat_parents = rtrim(get_category_parents($last_category->term_id, true, ','),',');
                $cat_parents = explode(',',$get_cat_parents);

                // Loop through parent categories and store in variable $cat_display
                $cat_display = '';
                foreach($cat_parents as $parents) {
                    $cat_display .= $before . ' class="item-cat">'.$parents.'' . $after;
                    if(!empty($settings['separator'])) {
                        $cat_display .= $before . ' class="separator">' . $settings['separator'] . $after;
                    }
                }

            }

            // If it's a custom post type within a custom taxonomy
            $taxonomy_exists = taxonomy_exists($custom_taxonomy);
            if(empty($last_category) && !empty($custom_taxonomy) && $taxonomy_exists) {

                $taxonomy_terms = get_the_terms( $post->ID, $custom_taxonomy );
                if(is_object($taxonomy_terms)) {
                    $cat_id         = $taxonomy_terms[0]->term_id;
                    $cat_nicename   = $taxonomy_terms[0]->slug;
                    $cat_link       = get_term_link($taxonomy_terms[0]->term_id, $custom_taxonomy);
                    $cat_name       = $taxonomy_terms[0]->name;
                }
            }

            // Check if the post is in a category
            if(!empty($last_category)) {
                $output .= $cat_display;
                $output .= $before . ' class="item-current item-' . $post->ID . '"><strong class="bread-current bread-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</strong>' . $after;

            // Else if post is in a custom taxonomy
            } else if(!empty($cat_id)) {

                $output .= $before . ' class="item-cat item-cat-' . $cat_id . ' item-cat-' . $cat_nicename . '"><a class="bread-cat bread-cat-' . $cat_id . ' bread-cat-' . $cat_nicename . '" href="' . $cat_link . '" title="' . $cat_name . '">' . $cat_name . '</a>' . $after;
                if(!empty($settings['separator'])) {
                    $output .= $before . ' class="separator">' . $settings['separator'] . $after;
                }
                $output .= $before . ' class="item-current item-' . $post->ID . '"><strong class="bread-current bread-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</strong>' . $after;

            } else {

                $output .= $before . ' class="item-current item-' . $post->ID . '"><strong class="bread-current bread-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</strong>' . $after;

            }

        } else if ( is_category() ) {

            // Category page
            $output .= $before . ' class="item-current item-cat"><strong class="bread-current bread-cat">' . single_cat_title('', false) . '</strong>' . $after;

        } else if ( is_page() ) {

            // Standard page
            if( $post->post_parent ){

                // If child page, get parents
                $anc = get_post_ancestors( $post->ID );

                // Get parents in the right order
                $anc = array_reverse($anc);

                // Parent page loop
                foreach ( $anc as $ancestor ) {
                    $parents .= $before . ' class="item-parent item-parent-' . $ancestor . '"><a class="bread-parent bread-parent-' . $ancestor . '" href="' . get_permalink($ancestor) . '" title="' . get_the_title($ancestor) . '">' . get_the_title($ancestor) . '</a>' . $after;
                    if(!empty($settings['separator'])) {
                        $parents .= $before . ' class="separator separator-' . $ancestor . '">' . $settings['separator'] . $after;
                    }
                }

                // Display parent pages
                $output .= $parents;

                // Current page
                $output .= $before . ' class="item-current item-' . $post->ID . '"><strong title="' . get_the_title() . '"> ' . get_the_title() . '</strong>' . $after;

            } else {

                // Just display current page if not parents
                $output .= $before . ' class="item-current item-' . $post->ID . '"><strong class="bread-current bread-' . $post->ID . '"> ' . get_the_title() . '</strong>' . $after;

            }

        } else if ( is_tag() ) {

            // Tag page

            // Get tag information
            $term_id        = get_query_var('tag_id');
            $taxonomy       = 'post_tag';
            $args           = 'include=' . $term_id;
            $terms          = get_terms( $taxonomy, $args );
            $get_term_id    = $terms[0]->term_id;
            $get_term_slug  = $terms[0]->slug;
            $get_term_name  = $terms[0]->name;

            // Display the tag name
            $output .= $before . ' class="item-current item-tag-' . $get_term_id . ' item-tag-' . $get_term_slug . '"><strong class="bread-current bread-tag-' . $get_term_id . ' bread-tag-' . $get_term_slug . '">' . $get_term_name . '</strong>' . $after;

        } elseif ( is_day() ) {

            // Day archive

            // Year link
            $output .= $before . ' class="item-year item-year-' . get_the_time('Y') . '"><a class="bread-year bread-year-' . get_the_time('Y') . '" href="' . get_year_link( get_the_time('Y') ) . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . ' Archives</a>' . $after;
            $output .= $before . ' class="separator separator-' . get_the_time('Y') . '"> ' . $separator . ' ' . $after;

            // Month link
            $output .= $before . ' class="item-month item-month-' . get_the_time('m') . '"><a class="bread-month bread-month-' . get_the_time('m') . '" href="' . get_month_link( get_the_time('Y'), get_the_time('m') ) . '" title="' . get_the_time('M') . '">' . get_the_time('M') . ' Archives</a>' . $after;
            $output .= $before . ' class="separator separator-' . get_the_time('m') . '"> ' . $separator . $after;

            // Day display
            $output .= $before . ' class="item-current item-' . get_the_time('j') . '"><strong class="bread-current bread-' . get_the_time('j') . '"> ' . get_the_time('jS') . ' ' . get_the_time('M') . ' Archives</strong>' . $after;

        } else if ( is_month() ) {

            // Month Archive

            // Year link
            $output .= $before . ' class="item-year item-year-' . get_the_time('Y') . '"><a class="bread-year bread-year-' . get_the_time('Y') . '" href="' . get_year_link( get_the_time('Y') ) . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . ' Archives</a>' . $after;
            $output .= $before . ' class="separator separator-' . get_the_time('Y') . '"> ' . $separator . $after;

            // Month display
            $output .= $before . ' class="item-month item-month-' . get_the_time('m') . '"><strong class="bread-month bread-month-' . get_the_time('m') . '" title="' . get_the_time('M') . '">' . get_the_time('M') . ' Archives</strong>' . $after;

        } else if ( is_year() ) {

            // Display year archive
            $output .= $before . ' class="item-current item-current-' . get_the_time('Y') . '"><strong class="bread-current bread-current-' . get_the_time('Y') . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . ' Archives</strong>' . $after;

        } else if ( is_author() ) {

            // Auhor archive

            // Get the author information
            global $author;
            $userdata = get_userdata( $author );

            // Display author name
            $output .= $before . ' class="item-current item-current-' . $userdata->user_nicename . '"><strong class="bread-current bread-current-' . $userdata->user_nicename . '" title="' . $userdata->display_name . '">' . 'Author: ' . $userdata->display_name . '</strong>' . $after;

        } else if ( get_query_var('paged') ) {

            // Paginated archives
            $output .= $before . ' class="item-current item-current-' . get_query_var('paged') . '"><strong class="bread-current bread-current-' . get_query_var('paged') . '" title="Page ' . get_query_var('paged') . '">'.esc_html__('Page', 'bookstore') . ' ' . get_query_var('paged') . '</strong>' . $after;

        } else if ( is_search() ) {

            // Search results page
            $output .= $before . ' class="item-current item-current-' . get_search_query() . '"><strong class="bread-current bread-current-' . get_search_query() . '" title="Search results for: ' . get_search_query() . '">Search results for: ' . get_search_query() . '</strong>' . $after;

        } elseif ( is_404() ) {

            // 404 page
            $output .= $before . '>' . 'Error 404' . $after;
        }

        $output .= $settings['wrap_after'];

        return $output;

    }

}
