<?php
class Bookstore_Social_networking_links extends WP_Widget {
	function __construct() {
	 	parent::__construct(
				    'wp-social-widget', // base ID of the widget
				    esc_html__ ('Social Icons Widget', 'bookstore' ), // name of the widget
				    // widget options
				    array (
				        'description' => esc_html__ ( 'Sharing Social networks link', 'bookstore' )
				    )
				);
	}

	function form( $instance ){
		// generate form		
		$defaults = array('title' => 'Image','icon_circle'=>'','background_color' => '', 'background_hover_color' => '','icon_color' => '', 'icon_hover_color' => '', 'mail' => '', 'rss' => '', 'behance' => '', 'foursquare' => '', 'skype' => '', 'soundcloud' => '', 'vine' => '', 'youtube' => '', 'vk' => '', 'xing' => '', 'yelp' => '', 'dribbble' => '', 'facebook' => '', 'flickr' => '', 'github' => '', 'google' => '', 'instagram' => '', 'linkedin' => '', 'pinterest' => '', 'stumbleupon' => '', 'tumblr' => '', 'twitter' => '', 'vimeo' => '');

		$title = isset($instance[ 'title' ])?$instance[ 'title' ]:'';
		$background_color = isset($instance[ 'background_color' ])?$instance[ 'background_color' ]:'';
		$background_hover_color = isset($instance[ 'background_hover_color' ])?$instance[ 'background_hover_color' ]:'';
		$icon_color = isset($instance[ 'icon_color' ])?$instance[ 'icon_color' ]:'';
		$icon_hover_color = isset($instance[ 'icon_hover_color' ])?$instance[ 'icon_hover_color' ]:'';
		$icon_circle = isset($instance[ 'icon_circle' ])?$instance[ 'icon_circle' ]:'';
		$mail = isset($instance['mail'])?$instance['mail']:'';
		$rss = isset($instance['rss'])?$instance['rss']:'';
		$behance = isset($instance['behance'])?$instance['behance']:'';
		$foursquare = isset($instance['foursquare'])?$instance['foursquare']:'';
		$skype = isset($instance['skype'])?$instance['skype']:'';
		$soundcloud = isset($instance['soundcloud'])?$instance['soundcloud']:'';
		$vine = isset($instance['vine'])?$instance['vine']:'';
		$vk = isset($instance['vk'])?$instance['vk']:'';
		$xing = isset($instance['xing'])?$instance['xing']:'';
		$yelp = isset($instance['yelp'])?$instance['yelp']:'';
		$youtube = isset($instance['youtube'])?$instance['youtube']:'';
		$dribbble = isset($instance['dribbble'])?$instance['dribbble']:'';
		$facebook = isset($instance['facebook'])?$instance['facebook']:'';
		$flickr = isset($instance['flickr'])?$instance['flickr']:'';
		$github = isset($instance['github'])?$instance['github']:'';
		$google = isset($instance['google'])?$instance['google']:'';
		$instagram = isset($instance['instagram'])?$instance['instagram']:'';
		$linkedin = isset($instance['linkedin'])?$instance['linkedin']:'';
		$pinterest = isset($instance['pinterest'])?$instance['pinterest']:'';
		$stumbleupon = isset($instance['stumbleupon'])?$instance['stumbleupon']:'';
		$tumblr = isset($instance['tumblr'])?$instance['tumblr']:'';
		$twitter = isset($instance['twitter'])?$instance['twitter']:'';
		$vimeo = isset($instance['vimeo'])?$instance['vimeo']:'';
		?>
                                    <div class="social_wdg_info"><br /><br />
                                        <a href="<?php echo admin_url( 'admin.php?page=bookstore_settings' ); ?>">Visit bookstore settings to set icon colors.</a>
                                    </div>
                                    
                                    
                                    <div class="social_wdg_info">
                                    <label>Title :</label>
                                    <input class="" type="text" id="<?php echo esc_html($this->get_field_id("mail")); ?>" name="<?php echo wp_kses_post($this->get_field_name("title")) ?>" value="<?php echo esc_attr($title)?>" />
                                    </div>

                                    <p>
                                    <label><span class="sicon-behance"></span> Behance link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("behance")) ?>" name="<?php echo wp_kses_post($this->get_field_name("behance")) ?>" value="<?php echo esc_attr($behance)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-dribbble"></span> Dribbble link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("dribbble")) ?>" name="<?php echo wp_kses_post($this->get_field_name("dribbble")) ?>" value="<?php echo esc_attr($dribbble)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-facebook"></span> Facebook link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("facebook")) ?>" name="<?php echo wp_kses_post($this->get_field_name("facebook")) ?>" value="<?php echo esc_attr($facebook)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-flickr"></span> Flickr link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("flickr")) ?>" name="<?php echo wp_kses_post($this->get_field_name("flickr")) ?>" value="<?php echo esc_attr($flickr)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-foursquare"></span> Foursquare link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("foursquare")) ?>" name="<?php echo wp_kses_post($this->get_field_name("foursquare")) ?>" value="<?php echo esc_attr($foursquare)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-github"></span> Github link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("github")) ?>" name="<?php echo wp_kses_post($this->get_field_name("github")) ?>" value="<?php echo esc_attr($github)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-google"></span> Google link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("google")) ?>" name="<?php echo wp_kses_post($this->get_field_name("google")) ?>" value="<?php echo esc_attr($google)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-instagram"></span> Instagram link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("instagram")) ?>" name="<?php echo wp_kses_post($this->get_field_name("instagram")) ?>" value="<?php echo esc_attr($instagram)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-linkedin"></span> Linkedin link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("linkedin")) ?>" name="<?php echo wp_kses_post($this->get_field_name("linkedin")) ?>" value="<?php echo esc_attr($linkedin)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-mail"></span> Mail link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("mail")) ?>" name="<?php echo wp_kses_post($this->get_field_name("mail")) ?>" value="<?php echo esc_attr($mail)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-pinterest"></span> Pinterest link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("pinterest")) ?>" name="<?php echo wp_kses_post($this->get_field_name("pinterest")) ?>" value="<?php echo esc_attr($pinterest)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-rss"></span> Rss link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("rss")) ?>" name="<?php echo wp_kses_post($this->get_field_name("rss")) ?>" value="<?php echo esc_attr($rss)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-skype"></span> Skype link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("skype")) ?>" name="<?php echo wp_kses_post($this->get_field_name("skype")) ?>" value="<?php echo esc_attr($skype)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-soundcloud"></span> Soundcloud link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("soundcloud")) ?>" name="<?php echo wp_kses_post($this->get_field_name("soundcloud")) ?>" value="<?php echo esc_attr($soundcloud)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-stumbleupon"></span> Stumbleupon link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("stumbleupon")) ?>" name="<?php echo wp_kses_post($this->get_field_name("stumbleupon")) ?>" value="<?php echo esc_attr($stumbleupon)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-tumblr"></span> Tumblr link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("tumblr")) ?>" name="<?php echo wp_kses_post($this->get_field_name("tumblr")) ?>" value="<?php echo esc_attr($tumblr)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-twitter"></span> Twitter link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("twitter")) ?>" name="<?php echo wp_kses_post($this->get_field_name("twitter")) ?>" value="<?php echo esc_attr($twitter)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-vimeo"></span> Vimeo link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("vimeo")) ?>" name="<?php echo wp_kses_post($this->get_field_name("vimeo")) ?>" value="<?php echo esc_attr($vimeo)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-vine"></span> Vine link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("vine")) ?>" name="<?php echo wp_kses_post($this->get_field_name("vine")) ?>" value="<?php echo esc_attr($vine)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-vk"></span> Vk link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("vk")) ?>" name="<?php echo wp_kses_post($this->get_field_name("vk")) ?>" value="<?php echo esc_attr($vk)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-xing"></span> Xing link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("xing")) ?>" name="<?php echo wp_kses_post($this->get_field_name("xing")) ?>" value="<?php echo esc_attr($xing)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-yelp"></span> Yelp link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("yelp")) ?>" name="<?php echo wp_kses_post($this->get_field_name("yelp")) ?>" value="<?php echo esc_attr($yelp)?>" />
                                    </p>

                                    <p>
                                    <label><span class="sicon-youtube"></span> Youtube link :</label>
                                    <input class="widefat" type="text" id="<?php echo esc_html($this->get_field_id("youtube")) ?>" name="<?php echo wp_kses_post($this->get_field_name("youtube")) ?>" value="<?php echo esc_attr($youtube)?>" />
                                    </p>

		<?php
	}

	function update( $new_instance, $old_instance ){
		$instance['title' ] = strip_tags( $new_instance['title' ] );

		$instance['background_color'] = $new_instance['background_color'];
		$instance['background_hover_color'] = $new_instance['background_hover_color'];
		$instance['icon_color'] = $new_instance['icon_color'];
		$instance['icon_hover_color'] = $new_instance['icon_hover_color'];
		$instance['icon_circle'] = $new_instance['icon_circle'];

		$instance['mail'] = strip_tags( $new_instance['mail'] );
		$instance['rss'] = strip_tags( $new_instance['rss'] );
		$instance['behance'] = strip_tags( $new_instance['behance'] );
		$instance['foursquare'] = strip_tags( $new_instance['foursquare'] );
		$instance['skype'] = strip_tags( $new_instance['skype'] );
		$instance['soundcloud'] = strip_tags( $new_instance['soundcloud'] );
		$instance['vine'] = strip_tags( $new_instance['vine'] );
		$instance['vk'] = strip_tags( $new_instance['vk'] );
		$instance['xing'] = strip_tags( $new_instance['xing'] );
		$instance['yelp'] = strip_tags( $new_instance['yelp'] );
		$instance['dribbble'] = strip_tags( $new_instance['dribbble'] );
		$instance['facebook'] = strip_tags( $new_instance['facebook'] );
		$instance['flickr'] = strip_tags( $new_instance['flickr'] );
		$instance['github'] = strip_tags( $new_instance['github'] );
		$instance['google'] = strip_tags( $new_instance['google'] );
		$instance['instagram'] = strip_tags( $new_instance['instagram'] );
		$instance['linkedin'] = strip_tags( $new_instance['linkedin'] );
		$instance['pinterest'] = strip_tags( $new_instance['pinterest'] );
		$instance['stumbleupon'] = strip_tags( $new_instance['stumbleupon'] );
		$instance['tumblr'] = strip_tags( $new_instance['tumblr'] );
		$instance['twitter'] = strip_tags( $new_instance['twitter'] );
		$instance['vimeo'] = strip_tags( $new_instance['vimeo'] );
		$instance['youtube'] = strip_tags( $new_instance['youtube'] );
		return $instance;
	}

	function widget( $args, $instance ) {
		// display in front end
		extract( $args );

		$instance['background_color'] = ( isset($instance['background_color']) && $instance['background_color']!="" )?$instance['background_color']:'#ffffff';
		$instance['background_hover_color'] = ( isset($instance['background_hover_color']) && $instance['background_hover_color'] !="" )?$instance['background_hover_color']:'#000000';
		$instance['icon_color'] = ( isset($instance['icon_color']) && $instance['icon_color'] !="" )?$instance['icon_color']:'#000000';
		$instance['icon_hover_color'] = ( isset($instance['icon_hover_color']) && $instance['icon_hover_color'] !="" )?$instance['icon_hover_color']:'#ffffff';
		
		$style = "<style type='text/css' scoped>
			body .social-links li a .social-icon {
				background: ".$instance['background_color'] ." !important;
				color:".$instance['icon_color']." !important;
			}

			body .social-links li a .social-icon:hover,
			body .social-links li a .social-icon:focus {
				background: ".$instance['background_hover_color'] ." !important;
				color:".$instance['icon_hover_color']." !important;

			}";
		if( "yes" == $instance['icon_circle'] ){
		$style .= " body .social-links li .social-icon, .social-icon:after {
                        -webkit-border-radius: 50%;
                        -moz-border-radius: 50%;
                        -ms-border-radius: 50%;
                        -o-border-radius: 50%;
                        border-radius: 50%;
                        }";
		}
		$style .= "</style>";


		//$socialBlock = $style;
                                        $socialBlock = "";
		$socialBlock .= $before_widget;
		if( isset($instance['title']) && $instance['title']!="" )
			$socialBlock .= $before_title . $instance['title'] . $after_title;
			$socialBlock .= "<ul class='social-links'>";
		
		if( isset($instance['behance']) && $instance['behance']!="" )
			$socialBlock .= '<li><a href="'.$instance['behance'].'" ><span class="social-icon sicon-behance"></span></a></li>';

		if( isset($instance['dribbble']) && $instance['dribbble']!="" )
			$socialBlock .= '<li><a href="'.$instance['dribbble'].'" ><span class="social-icon sicon-dribbble"></span></a></li>';

		if( isset($instance['facebook']) && $instance['facebook']!="" )
			$socialBlock .= '<li><a href="'.$instance['facebook'].'" ><span class="social-icon sicon-facebook"></span></a></li>';

		if( isset($instance['flickr']) && $instance['flickr']!="" )
			$socialBlock .= '<li><a href="'.$instance['flickr'].'" ><span class="social-icon sicon-flickr"></span></a></li>';
		
		if( isset($instance['foursquare']) && $instance['foursquare']!="" )
			$socialBlock .= '<li><a href="'.$instance['foursquare'].'" ><span class="social-icon sicon-foursquare"></span></a></li>';

		if( isset($instance['github']) && $instance['github']!="" )
			$socialBlock .= '<li><a href="'.$instance['github'].'" ><span class="social-icon sicon-github"></span></a></li>';

		if( isset($instance['google']) && $instance['google']!="" )
			$socialBlock .= '<li><a href="'.$instance['google'].'" ><span class="social-icon sicon-google"></span></a></li>';

		if( isset($instance['instagram']) && $instance['instagram']!="" )
			$socialBlock .= '<li><a href="'.$instance['instagram'].'" ><span class="social-icon sicon-instagram"></span></a></li>';

		if( isset($instance['linkedin']) && $instance['linkedin']!="" )
			$socialBlock .= '<li><a href="'.$instance['linkedin'].'" ><span class="social-icon sicon-linkedin"></span></a></li>';

		if( isset($instance['mail']) && $instance['mail']!="" )
			$socialBlock .= '<li><a href="mailto'.$instance['mail'].'" ><span class="social-icon sicon-mail"></span></a></li>';

		if( isset($instance['pinterest']) && $instance['pinterest']!="" )
			$socialBlock .= '<li><a href="'.$instance['pinterest'].'" ><span class="social-icon sicon-pinterest"></span></a></li>';

		if( isset($instance['rss']) && $instance['rss']!="" )
			$socialBlock .= '<li><a href="'.$instance['rss'].'" ><span class="social-icon sicon-rss"></span></a></li>';

		if( isset($instance['skype']) && $instance['skype']!="" )
			$socialBlock .= '<li><a href="'.$instance['skype'].'" ><span class="social-icon sicon-skype"></span></a></li>';

		if( isset($instance['soundcloud']) && $instance['soundcloud']!="" )
			$socialBlock .= '<li><a href="'.$instance['soundcloud'].'" ><span class="social-icon sicon-soundcloud"></span></a></li>';

		if( isset($instance['stumbleupon']) && $instance['stumbleupon']!="" )
			$socialBlock .= '<li><a href="'.$instance['stumbleupon'].'" ><span class="social-icon sicon-stumbleupon"></span></a></li>';

		if( isset($instance['tumblr']) && $instance['tumblr']!="" )
			$socialBlock .= '<li><a href="'.$instance['tumblr'].'" ><span class="social-icon sicon-tumblr"></span></a></li>';

		if( isset($instance['twitter']) && $instance['twitter']!="" )
			$socialBlock .= '<li><a href="'.$instance['twitter'].'" ><span class="social-icon sicon-twitter"></span></a></li>';

		if( isset($instance['vimeo']) && $instance['vimeo']!="" )
			$socialBlock .= '<li><a href="'.$instance['vimeo'].'" ><span class="social-icon sicon-vimeo"></span></a></li>';

		if( isset($instance['vine']) && $instance['vine']!="" )
			$socialBlock .= '<li><a href="'.$instance['vine'].'" ><span class="social-icon sicon-vine"></span></a></li>';

		if( isset($instance['vk']) && $instance['vk']!="" )
			$socialBlock .= '<li><a href="'.$instance['vk'].'" ><span class="social-icon sicon-vk"></span></a></li>';
		
		if( isset($instance['xing']) && $instance['xing']!="" )
			$socialBlock .= '<li><a href="'.$instance['xing'].'" ><span class="social-icon sicon-xing"></span></a></li>';

		if( isset($instance['yelp']) && $instance['yelp']!="" )
			$socialBlock .= '<li><a href="'.$instance['yelp'].'" ><span class="social-icon sicon-yelp"></span></a></li>';
		
		if( isset($instance['youtube']) && $instance['youtube']!="" )
			$socialBlock .= '<li><a href="'.$instance['youtube'].'" ><span class="social-icon sicon-youtube"></span></a></li>';

		$socialBlock .= "</ul>";

		$socialBlock .= $after_widget;

		echo wp_kses_post($socialBlock);
	}	 
}

function bookstore_register_social_network() {
    register_widget( 'Bookstore_Social_networking_links' );
}
add_action( 'widgets_init', 'bookstore_register_social_network' );