<?php
/**
 * The default template for blog single post page
 * 
 * @package   bookstore
 * @author    AcmeeDesign
 * @link      http://acmeedesign.com
 * @since     1.0
 */

get_header();

echo wp_kses_post(bookstore_breadcrumb('page-header'));

$bookstore_options = (function_exists('bookstore_options')) ? bookstore_options() : "";

if(isset($bookstore_options['blog_sidebar_position']) && $bookstore_options['blog_sidebar_position'] == "left") {
    $content_class = "right";
    $sidebar_class = "left";
}
else {
    $content_class = "left";
    $sidebar_class = "right";
}

?>

<div class="container padding-40-v">
    <div id="main-content">
        <div id="content" role="main" class="col-xs-12 col-sm-8 col-md-9 <?php echo esc_html($content_class); ?>">
            <?php while ( have_posts() ) : the_post(); ?>
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

                    <header class="entry-header">
                        <div class="post-categories clearfix">
                            <?php echo get_the_category_list(); ?>
                        </div>

                         <?php
                            if ( !is_single() ) :
                                    the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
                            endif;
                            ?>

                        <div class="post-meta">
                            <span class="author"><i class="fa fa-user"></i> written by <?php esc_url(the_author_posts_link()); ?></span>
                            <span class="author"><i class="fa fa-clock-o"></i> <?php echo get_the_date('l, d F Y'); ?></span>
                        </div>

                        <?php
                            if( has_post_thumbnail() ){
                                    the_post_thumbnail('bookstore_blog_thumb', array('class' => 'img-responsive blog-thumbnail'));
                            }
                            ?>                    

                    </header><!-- .entry-header -->

                    <div class="entry-content clearfix">
                        <div class="post-content">
                            <?php
                                   the_content();
                                    wp_link_pages( array(
                                            'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'bookstore' ) . '</span>',
                                            'after'       => '</div>',
                                            'link_before' => '<span>',
                                            'link_after'  => '</span>',
                                            'pagelink'    => '<span class="screen-reader-text">' . __( 'Page', 'bookstore' ) . ' </span>%',
                                            'separator'   => '<span class="screen-reader-text">, </span>',
                                    ) );
        ?>
                        </div>
                    </div><!-- .entry-content -->
                    
                    <footer class="entry-footer">
                        <div class="tags">
                            <span><strong><?php esc_html_e('Tags: ','bookstore'); ?></strong> <?php echo get_the_tag_list('', ', ')?></span>
                        </div>
                    </footer>

                </article><!-- #post-## -->
                
                <?php if(!empty($bookstore_options['show_author_bio'])) { 
                    $author_id = get_the_author_meta('ID');
                    $author_name = get_the_author_meta('first_name');
                    if( !empty($author_name) ) {
                        $author_dis_name = get_the_author_meta('first_name') . " " . get_the_author_meta('last_name');
                    } 
                    else {
                        $author_dis_name = get_the_author_meta('display_name') ;
                    }
                    ?>
                <div class="author-bio">
                    <div class="clearfix">
                        <div class="col-sm-2">
                            <?php echo get_avatar( $author_id, 100, '', $author_dis_name ); ?>
                        </div>
                        <div class="col-sm-10">
                            <h3 class="author-name"><a href="<?php echo esc_url(get_author_posts_url($author_id)); ?>"><?php echo esc_html($author_dis_name); ?></a></h3>
                            <div class="author-info">
                                <?php echo get_the_author_meta('description'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php } ?>
                
                <?php
                        // If comments are open or we have at least one comment, load up the comment template
                        if ( comments_open() || '0' != get_comments_number() )
                                comments_template();
                ?>
                <?php endwhile; // end of the loop. ?>
        </div><!-- #content -->
        
        <div id="blog-sidebar" class="sidebar col-xs-12 col-sm-4 col-md-3 <?php echo esc_html($sidebar_class); ?>">
            <?php get_sidebar(); ?>
        </div><!-- #sidebar -->

    </div><!-- .main-content -->
    
</div><!-- .container -->

<?php 
//get footer file
get_footer();
